% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/percentile_from_red_noise.R
\name{percentile_from_red_noise}
\alias{percentile_from_red_noise}
\title{Calculate average spectral power from red noise curves for a given percentile}
\usage{
percentile_from_red_noise(red_noise = NULL, wavelet = NULL, percentile = NULL)
}
\arguments{
\item{red_noise}{Red noise curves generated using the \code{\link{model_red_noise_wt}} function.}

\item{wavelet}{Wavelet object created using the \code{\link{analyze_wavelet}} function.}

\item{percentile}{Percentile value (0-1).}
}
\value{
Returns a matrix with 2 columns.\cr
The first column is the period (m). \cr
The second column is the spectral power at percentile x based on \cr
the red noise modelling runs. \cr
}
\description{
The \code{\link{percentile_from_red_noise}} function is
used to generate and average spectral power curve based on
a set percentile based. To generate the percentile curve the results of
 the \code{\link{model_red_noise_wt}} function are used.
}
\examples{
\donttest{
#'#generate average spectral power curves based on red noise curves which are
# based on the magnetic susceptibility record of the Sullivan core of Pas et al., (2018)

mag_wt <- analyze_wavelet(data = mag,
dj = 1/100,
lowerPeriod = 0.1,
upperPeriod = 254,
verbose = FALSE,
omega_nr = 10)

#increase n_simulations to better define the red noise spectral power curve
mag_wt_red_noise <- model_red_noise_wt(wavelet=mag_wt,
n_simulations=100,
run_multicore=FALSE,
verbose=FALSE)


prob_curve <- percentile_from_red_noise(
red_noise = mag_wt_red_noise,
wavelet = mag_wt,
percentile = 0.9
)
}

}
