% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Computation.r
\name{computeInformationCostsThreshold}
\alias{computeInformationCostsThreshold}
\title{Computes the information costs threshold}
\usage{
computeInformationCostsThreshold(campaign)
}
\arguments{
\item{campaign}{Word-of-Mouth campaign as instance of class \code{WoMCampaign}.}
}
\value{
Information costs in [0; 1] that need to be surpassed in order to generate a higher profit than in a 
transparent market.
}
\description{
Computes the information costs that need to be surpassed in order to generate a higher profit than in 
a transparent market.
}
\examples{

network <- new("WoMNetwork", size = 1000, avgConnections = 5)
campaign <- new("WoMCampaign", network = network, seedingSize = 10, forwardProbability = 0.2)
threshold <- computeInformationCostsThreshold(campaign)
print(threshold)

}
\seealso{
\code{\link{computeOptimalPrice}} \code{\link{computeProfit}}
}
\author{
Michael Scholz \email{michael.scholz@th-deg.de}

Thomas Woehner \email{Thomas.Woehner@eah-jena.de}

Ralf Peters \email{ralf.peters@wiwi.uni-halle.de}
}
