% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addPlots.R
\name{addPlots}
\alias{addPlots}
\title{Read Word document with bookmarks and create other Word document with rendered plots in place.}
\usage{
addPlots(
  docxIn,
  docxOut,
  Plots = list(),
  width = 6,
  height = 6,
  res = 300,
  style = NULL,
  debug = F,
  ...
)
}
\arguments{
\item{docxIn}{String of length one; path to Word file with bookmarks OR officer::rdocx object}

\item{docxOut}{String of length one; path for output Word file or NA}

\item{Plots}{Named list of functions (or plots - for plots which are stored as objects e.g., ggplot) creating plots to be inserted into the Word file}

\item{width}{width of the plots in output in inches, either of length 1 (and will be recycled), or same length as Plots}

\item{height}{height of the plots in output in inches, either of length 1 (and will be recycled), or same length as Plots}

\item{res}{see res parameter in \code{\link[grDevices]{png}}}

\item{style}{see style parameter in \code{\link[officer]{body_add_img}}}

\item{debug}{Boolean of length one; If \code{True} then \code{\link[base]{browser}()} is called at the beginning of the function}

\item{...}{Parameters to be sent to other methods (\code{\link[grDevices]{png}})}
}
\value{
Path to the rendered Word file if the operation was successfull OR officer::rdocx object if docxOut is NA
}
\description{
This function takes a list of functions creating plots and insert into Word document on places with correspondning bookmarks.
}
\examples{
library(ggplot2)
Plots<-list(plot1=function()plot(hp~wt,data=mtcars,col=cyl),
 plot2=function()print(ggplot(mtcars,aes(x=wt,y=hp,col=as.factor(cyl)))+geom_point()))
addPlots(
 paste(examplePath(),'templates/templatePlots.docx',sep = ''),
 paste(tempdir(),'/resultPlots.docx',sep = ''),
 Plots,height=4)

}
