% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xCircos.r
\name{xCircos}
\alias{xCircos}
\title{Function to visualise a network as a circos plot}
\usage{
xCircos(g, entity = c("SNP", "Gene", "Both"), top_num = 50,
colormap = c("yr", "bwr", "jet", "gbr", "wyr", "br", "rainbow", "wb",
"lightyellow-orange"), rescale = T, nodes.query = NULL, ideogram = T,
chr.exclude = "auto", entity.label.cex = 0.7,
entity.label.side = c("in", "out"), entity.label.track = 1,
entity.label.query = NULL, GR.SNP = c("dbSNP_GWAS", "dbSNP_Common"),
GR.Gene = c("UCSC_knownGene", "UCSC_knownCanonical"), verbose = T,
RData.location = "http://galahad.well.ox.ac.uk/bigdata")
}
\arguments{
\item{g}{an object of class "igraph". For example, it stores semantic
similarity results with nodes for genes/SNPs and edges for pair-wise
semantic similarity between them}

\item{entity}{the entity of similarity analysis for which results are
being plotted. It can be either "SNP" or "Gene"}

\item{top_num}{the top number of similarity edges to be plotted}

\item{colormap}{short name for the colormap. It can be one of "jet"
(jet colormap), "bwr" (blue-white-red colormap), "gbr" (green-black-red
colormap), "wyr" (white-yellow-red colormap), "br" (black-red
colormap), "yr" (yellow-red colormap), "wb" (white-black colormap), and
"rainbow" (rainbow colormap, that is,
red-yellow-green-cyan-blue-magenta). Alternatively, any
hyphen-separated HTML color names, e.g. "lightyellow-orange" (by
default), "blue-black-yellow", "royalblue-white-sandybrown",
"darkgreen-white-darkviolet". A list of standard color names can be
found in \url{http://html-color-codes.info/color-names}}

\item{rescale}{logical to indicate whether the edge values are rescaled
to the range [0,1]. By default, it sets to true}

\item{nodes.query}{nodes in query for which edges attached to them will
be displayed. By default, it sets to NULL meaning no such restriction}

\item{ideogram}{logical to indicate whether chromosome banding is
plotted}

\item{chr.exclude}{a character vector of chromosomes to exclude from
the plot, e.g. c("chrX", "chrY"). By defautl, it is 'auto' meaning
those chromosomes without data will be excluded. If NULL, no chromosome
is excluded}

\item{entity.label.cex}{the font size of genes/SNPs labels. Default is
0.8}

\item{entity.label.side}{the position of genes/SNPs labels relative to
chromosome ideogram. It can be "out" (by default) or "in"}

\item{entity.label.track}{an integer specifying the plot track for
genes/SNPs labels. Default is 1}

\item{entity.label.query}{which genes/SNPs labels in query will be
displayed. By default, it sets to NULL meaning all will be displayed.
If labes in query can not be found, then all will be displayed}

\item{GR.SNP}{the genomic regions of SNPs. By default, it is
'dbSNP_GWAS', that is, SNPs from dbSNP (version 146) restricted to GWAS
SNPs and their LD SNPs (hg19). It can be 'dbSNP_Common', that is,
Common SNPs from dbSNP (version 146) plus GWAS SNPs and their LD SNPs
(hg19). Alternatively, the user can specify the customised input. To do
so, first save your RData file (containing an GR object) into your
local computer, and make sure the GR object content names refer to
dbSNP IDs. Then, tell "GR.SNP" with your RData file name (with or
without extension), plus specify your file RData path in
"RData.location". Note: you can also load your customised GR object
directly}

\item{GR.Gene}{the genomic regions of genes. By default, it is
'UCSC_knownGene', that is, UCSC known genes (together with genomic
locations) based on human genome assembly hg19. It can be
'UCSC_knownCanonical', that is, UCSC known canonical genes (together
with genomic locations) based on human genome assembly hg19.
Alternatively, the user can specify the customised input. To do so,
first save your RData file (containing an GR object) into your local
computer, and make sure the GR object content names refer to Gene
Symbols. Then, tell "GR.Gene" with your RData file name (with or
without extension), plus specify your file RData path in
"RData.location". Note: you can also load your customised GR object
directly}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to true for display}

\item{RData.location}{the characters to tell the location of built-in
RData files. See \code{\link{xRDataLoader}} for details}
}
\value{
a circos plot with edge weights between input snps/genes represented by
the colour of the links
}
\description{
\code{xCircos} is used to visualise a network as a circos plot. The
network must be a 'igraph' object. The degree of similarity between
SNPs (or genes) is visualised by the colour of links. This function can
be used either to visualise the most similar links or to plot links
involving an input SNP (or gene).
}
\note{
none
}
\examples{
\dontrun{
# Load the XGR package and specify the location of built-in data
library(XGR)
RData.location <- "http://galahad.well.ox.ac.uk/bigdata_dev/"

library(RCircos)

# provide genes and SNPs reported in GWAS studies
ImmunoBase <- xRDataLoader(RData.customised='ImmunoBase',
RData.location=RData.location)

# 1) SNP-based similarity analysis using GWAS Catalog traits (mapped to EF)
## Get lead SNPs reported in AS GWAS
example.snps <- names(ImmunoBase$AS$variants)
SNP.g <- xSocialiserSNPs(example.snps, include.LD=NA,
RData.location=RData.location)
# Circos plot of the EF-based SNP similarity network
#out.file <- "SNP_Circos.pdf"
#pdf(file=out.file, height=12, width=12, compress=TRUE)
xCircos(g=SNP.g, entity="SNP", RData.location=RData.location)
#dev.off()
# Circos plot involving nodes 'rs6871626'
xCircos(g=SNP.g, entity="SNP", nodes.query="rs6871626",
RData.location=RData.location)

# 2) Gene-based similarity analysis using Disease Ontology (DO)
## Get genes within 10kb away from AS GWAS lead SNPs
example.genes <- names(which(ImmunoBase$AS$genes_variants<=10000))
gene.g <- xSocialiserGenes(example.genes, ontology="DO",
RData.location=RData.location)
# Circos plot of the DO-based gene similarity network
#out.file <- "Gene_Circos.pdf"
#pdf(file=out.file, height=12, width=12, compress=TRUE)
xCircos(g=gene.g, entity="Gene", chr.exclude="chrY",
RData.location=RData.location)
#dev.off()

# 3) Advanced usages: Gene-SNP pairs from trans-eQTL mapping
JKscience_TS3A <- xRDataLoader(RData.customised='JKscience_TS3A',
RData.location=RData.location)
## extract the significant trans-eQTL in IFN
ind <- -1*log10(JKscience_TS3A$IFN_fdr)
ind <- which(!is.na(ind) & ind>2)
relations <- JKscience_TS3A[ind, c("Symbol","variant","IFN_fdr")]
relations <- data.frame(from=relations$Symbol, to=relations$variant,
weight=-log10(relations$IFN_fdr))
ig_Gene2SNP <- igraph::graph.data.frame(d=relations, directed=TRUE)
# Circos plot of the eQTL (Gene-SNP) network
#out.file <- "eQTL_Circos.pdf"
#pdf(file=out.file, height=12, width=12, compress=TRUE)
xCircos(g=ig_Gene2SNP, entity="Both", top_num=NULL,
nodes.query=c("GAD1","TNFRSF1B"), chr.exclude=NULL,
entity.label.side="out", RData.location=RData.location)
#dev.off()
}
}
\seealso{
\code{\link{xSocialiserGenes}}, \code{\link{xSocialiserSNPs}}
}

