% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xSubneterGenesMST.r
\name{xSubneterGenesMST}
\alias{xSubneterGenesMST}
\title{Function to identify a minimum spanning tree for subnetworks}
\usage{
xSubneterGenesMST(isubg, metric = c("hybrid", "max", "jaccard"),
verbose = T)
}
\arguments{
\item{isubg}{an "iSubg" object resulting from
\code{\link{xSubneterGenesAdv}}}

\item{metric}{the distance metric for subnetworks. It can be either
"max" for the maximum distance between any two nodes (one from a
subnetwork, and other from another subnetwork) based on the whole
network, or "jaccard" for jaccard distance between two subnetworks
(nodes overlapped), or "hybrid" (that is, "max" multiplied by
"jaccard")}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to true for display}
}
\value{
a minimum spanning tree, an object of class "igraph". It has graph
attributes ('summary', 'detail' and 'matrix'), and node attributes
('xcoord', 'ycoord', 'num_nodes', 'num_edges', 'weight' and
'weight_scaled' [1,5] for visualisation).
}
\description{
\code{xSubneterGenesAdv} is supposed to identify a minimum spanning
tree for subnetworks. It returns an object of class "igraph".
}
\examples{
\dontrun{
# Load the XGR package and specify the location of built-in data
library(XGR)
RData.location <- "http://galahad.well.ox.ac.uk/bigdata/"

# a) provide the input nodes/genes with the significance info
## load human genes
org.Hs.eg <- xRDataLoader(RData='org.Hs.eg',
RData.location=RData.location)
sig <- rbeta(500, shape1=0.5, shape2=1)
data <- data.frame(symbols=org.Hs.eg$gene_info$Symbol[1:500], sig)

# b) find a series of maximum-scoring subnets with the desired node number=50
isubg <- xSubneterGenesAdv(data=data, network="STRING_high",
subnet.size=50, RData.location=RData.location)

# c) represent a series of subnets as a minimum spanning tree
mst <- xSubneterGenesMST(isubg)
mst$summary
head(mst$detail)
head(mst$matrix)
gp_mst <- xGGnetwork(mst, node.label='name', node.label.size=3,
node.label.force=1, node.xcoord='xcoord', node.ycoord='ycoord',
edge.size='weight_scaled', node.size='num_edges', node.size.title="Num
of \nedges", node.size.range=c(1,4))
}
}
\seealso{
\code{\link{xSubneterGenesAdv}}
}
