% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/RJuliaConnect.R
\docType{class}
\name{JuliaInterface-class}
\alias{JuliaInterface}
\alias{JuliaInterface-class}
\title{An Interface to Julia}
\description{
The JuliaInterface class provides an evaluator for computations in Julia, following the structure
in the XR  package.  Proxy functions and classes allow use of the interface with no explicit
reference to the evaluator.  The function \code{RJulia()} returns an evaluator object.
}
\section{Fields}{

\describe{
\item{\code{port,host}}{The parameters for communicating with the Julia evaluator.}

\item{\code{julia\_bin}}{The command for starting a Julia process.}

\item{\code{connection}}{The connection object through which commands are sent to Julia}
}}
\section{Methods}{

\describe{
\item{\code{Import(module = "", ..., .command = if (identical(members, "*")) "using"
  else "import")}}{import the specified Julia module, optionally for the names provided in the "..."  arguments.  May also be used to invoke the "using" command by giving "*" as the names. In this case multiple modules can be imported by supplying a vector of length > 1 for module. All the exported objects in those modules will be available unqualified.}

\item{\code{initialize(..., startJulia = identical(host, "localhost"), verbose = FALSE)}}{The initialize method attempts to open a socket unless the "connection" field in the call is an open socket.  Else, if the host is the local host an attempt is made to start a Julia process.  See the documentation of the interface class for details.}

\item{\code{ProxyClassName(serverClass)}}{Find the proxy class name for a Julia composite type.  Uses the templated version if that has been
defined, otherwise the general untemplated one.}

\item{\code{ServerAddToPath(serverDirectory, serverPos = NA)}}{Julia version of the AddToPath method.}

\item{\code{ServerTask(task, expr, key = "", get = NA)}}{Call the task operation in the Julia code for the interface; the arguments must
be the simple strings or logical value expected.}

\item{\code{Source(filename)}}{Julia version of the $Source() method, using the include command in Julia}

\item{\code{Using(...)}}{The Julia "using" form of importing.  Arguments are module names.  All the exported
members of these modules will then be available, without prefix.}
}}

