% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object.wrapper.R
\name{vt.data}
\alias{vt.data}
\title{Initialize virtual twins data}
\usage{
vt.data(dataset, outcome.field, treatment.field, interactions = TRUE, ...)
}
\arguments{
\item{dataset}{data.frame representing RCT's}

\item{outcome.field}{name of the outcome's field in \code{dataset}}

\item{treatment.field}{name of the treatment's field in \code{dataset}}

\item{interactions}{logical. If running VirtualTwins with treatment's 
interactions, set to TRUE (default value)}

\item{...}{parameters of \code{\link{VT.object}}}
}
\value{
\code{VT.object}
}
\description{
\code{vt.data} is a wrapper of \code{\link{formatRCTDataset}} and 
\code{\link{VT.object}}. Allows to format your data.frame in order to create
a VT.object object.
}
\examples{
\dontrun{
 data(sepsis)
 formatRCTdataset(sepsis, "survival", "THERAPY", T)
}
  
}

