% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aba_fit.R
\name{aba_fit}
\alias{aba_fit}
\title{Fit an aba model.}
\usage{
aba_fit(object, ...)
}
\arguments{
\item{object}{aba model The aba model to be fitted.}

\item{...}{additional parameters.}
}
\value{
abaModel
}
\description{
Calling \code{aba_fit} will trigger the fitting of all statistical models which
have been specified for the model. This will result in fits for each
group - outcome - stat combination.
}
\details{
Note that this function is identical to the generic \code{fit()} function which
is also provided for compatability with the greater R ecosystem.
}
\examples{

data <- adnimerge \%>\% dplyr::filter(VISCODE == 'bl')

model_spec <- aba_model() \%>\%
  set_data(data) \%>\%
  set_groups(everyone()) \%>\%
  set_outcomes(ConvertedToAlzheimers, CSF_ABETA_STATUS_bl) \%>\%
  set_predictors(
    PLASMA_ABETA_bl, PLASMA_PTAU181_bl, PLASMA_NFL_bl,
    c(PLASMA_ABETA_bl, PLASMA_PTAU181_bl, PLASMA_NFL_bl)
  ) \%>\%
  set_stats('glm')

model <- model_spec \%>\% aba_fit()

}
