% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.abclass.R
\name{cv.abclass}
\alias{cv.abclass}
\title{Tune Angle-Based Classifiers by Cross-Validation}
\usage{
cv.abclass(
  x,
  y,
  intercept = TRUE,
  weight = NULL,
  loss = c("logistic", "boost", "hinge-boost", "lum"),
  control = list(),
  nfolds = 5L,
  stratified = TRUE,
  alignment = c("fraction", "lambda"),
  refit = FALSE,
  ...
)
}
\arguments{
\item{x}{A numeric matrix representing the design matrix.  No missing valus
are allowed.  The coefficient estimates for constant columns will be
zero.  Thus, one should set the argument \code{intercept} to \code{TRUE}
to include an intercept term instead of adding an all-one column to
\code{x}.}

\item{y}{An integer vector, a character vector, or a factor vector
representing the response label.}

\item{intercept}{A logical value indicating if an intercept should be
considered in the model.  The default value is \code{TRUE} and the
intercept is excluded from regularization.}

\item{weight}{A numeric vector for nonnegative observation weights. Equal
observation weights are used by default.}

\item{loss}{A character value specifying the loss function.  The available
options are \code{"logistic"} for the logistic deviance loss,
\code{"boost"} for the exponential loss approximating Boosting machines,
\code{"hinge-boost"} for hybrid of SVM and AdaBoost machine, and
\code{"lum"} for largin-margin unified machines (LUM).  See Liu, et
al. (2011) for details.}

\item{control}{A list of control parameters. See \code{abclass.control()}
for details.}

\item{nfolds}{A positive integer specifying the number of folds for
cross-validation.  Five-folds cross-validation will be used by default.
An error will be thrown out if the \code{nfolds} is specified to be less
than 2.}

\item{stratified}{A logical value indicating if the cross-validation
procedure should be stratified by the response label. The default value
is \code{TRUE} to ensure the same number of categories be used in
validation and training.}

\item{alignment}{A character vector specifying how to align the lambda
sequence used in the main fit with the cross-validation fits.  The
available options are \code{"fraction"} for allowing cross-validation
fits to have their own lambda sequences and \code{"lambda"} for using
the same lambda sequence of the main fit.  The option \code{"lambda"}
will be applied if a meaningful \code{lambda} is specified.  The default
value is \code{"fraction"}.}

\item{refit}{A logical value or a named list specifying if and how a refit
for those selected predictors should be performed.  The default valie is
\code{FALSE}.}

\item{...}{Other control parameters passed to \code{abclass.control()}.}
}
\value{
An S3 object of class \code{cv.abclass}.
}
\description{
Tune the regularization parameter for an angle-based large-margin classifier
by cross-validation.
}
