% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.supclass.R
\name{cv.supclass}
\alias{cv.supclass}
\title{Tune Sup-Norm Classifiers by Cross-Validation}
\usage{
cv.supclass(
  x,
  y,
  model = c("logistic", "psvm", "svm"),
  penalty = c("lasso", "scad"),
  start = NULL,
  control = list(),
  nfolds = 5L,
  stratified = TRUE,
  ...
)
}
\arguments{
\item{x}{A numeric matrix representing the design matrix.  No missing valus
are allowed.  The coefficient estimates for constant columns will be
zero.  Thus, one should set the argument \code{intercept} to \code{TRUE}
to include an intercept term instead of adding an all-one column to
\code{x}.}

\item{y}{An integer vector, a character vector, or a factor vector
representing the response label.}

\item{model}{A charactor vector specifying the classification model.  The
available options are \code{"logistic"} for multi-nomial logistic
regression model, \code{"psvm"} for proximal support vector machine
(PSVM), \code{"svm"} for multi-category support vector machine.}

\item{penalty}{A charactor vector specifying the penalty function for the
sup-norms.  The available options are \code{"lasso"} for sup-norm
regularization proposed by Zhang et al. (2008) and \code{"scad"} for
supSCAD regularization proposed by Li & Zhang (2021).}

\item{start}{A numeric matrix representing the starting values for the
quadratic approximation procedure behind the scene.}

\item{control}{A list with named elements.}

\item{nfolds}{A positive integer specifying the number of folds for
cross-validation.  Five-folds cross-validation will be used by default.
An error will be thrown out if the \code{nfolds} is specified to be less
than 2.}

\item{stratified}{A logical value indicating if the cross-validation
procedure should be stratified by the response label. The default value
is \code{TRUE} to ensure the same number of categories be used in
validation and training.}

\item{...}{Other arguments passed to \code{supclass}.}
}
\value{
An S3 object of class \code{cv.supclass}.
}
\description{
Tune the regularization parameter lambda for a sup-norm classifier by
cross-validation.
}
