\name{Crickets}
\alias{Crickets}
\docType{data}

\title{
Immunity and Sperm Viability in Crickets
}

\description{
Sperm viability and immune function, measured by lysozyme activity in crickets. Each observation is a mean for a single family of males.
}

\usage{data(Crickets)}
\format{
  A data frame with 41 observations on the following 2 variables.
  \describe{
    \item{\code{sperm.viability}}{a numeric vector}
    \item{\code{lysozyme}}{a numeric vector}
  }
}

%\details{
%%  ~~ If necessary, more details than the __description__ above ~~
%}

\source{
Simmons, L.W. and B. Roberts. 2005. Bacterial immunity traded for sperm viability in male crickets. \emph{Science} 309: 2031.
}

%\references{
%%  ~~ possibly secondary sources and usages ~~
%}

\examples{
data(Crickets)
Crickets
xyplot(lysozyme ~ sperm.viability, Crickets)
}

\keyword{datasets}
