% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abms.R
\name{gen_base_NegBinomial_reg}
\alias{gen_base_NegBinomial_reg}
\title{Negative Binomial Regression Data generator}
\usage{
gen_base_NegBinomial_reg(N, beta, r, Covariates)
}
\arguments{
\item{N}{The number of observations that will be generated. It must be a positive integer.}

\item{beta}{A vector of coefficients including the intercept. It can be a matrix.}

\item{r}{The number of success parameter. It must be a positive integer.}

\item{Covariates}{A data.frame object with the predictors (without intercept) for which we want to test if they are relevant to the response variable. It can also be a (\eqn{n x p}) matrix.}
}
\value{
The function return a sample of size N from the Negative binomial distribution indexed with the predictors indicated in the \code{Covariates} argument, and the predictors for each individual.
}
\description{
It generates \code{N} observations of the Negative binomial distribution with parameters \code{r} (number of success) and \eqn{p} (success probability), where the coefficients are indexed on \eqn{p} via the logistic function.
}
\examples{
N<-10   #Number of extractions
beta<-c(0.5, -0.8,  1.0,  0,  0.4, -0.7)  #Coefficient vector
p<-length(beta)
r<-2    #Number of success parameter
aux_cov<-rnorm((p-1)*N, 0,1)
Covariates<-data.frame(matrix(aux_cov, ncol=p-1, nrow=N))   #Generating the Covariates data.frame
colnames(Covariates)<-c("X1", "X2", "X3", "X4", "X5")
base<-gen_base_NegBinomial_reg(N, beta, r, Covariates)    #Generating the data
base
}
