% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_user_tweetsv2.R
\name{get_user_tweets}
\alias{get_user_tweets}
\title{Get tweets from user}
\usage{
get_user_tweets(
  users,
  start_tweets,
  end_tweets,
  bearer_token,
  file = NULL,
  data_path = NULL,
  bind_tweets = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{users}{character vector, user handles from which to collect data}

\item{start_tweets}{string, starting date}

\item{end_tweets}{string, ending date}

\item{bearer_token}{string, bearer token}

\item{file}{string, name of the resulting RDS file}

\item{data_path}{string, if supplied, fetched data can be saved to the designated path as jsons}

\item{bind_tweets}{If \code{TRUE}, tweets captured are bound into a data.frame for assignment}

\item{verbose}{If \code{FALSE}, query progress messages are suppressed}
}
\value{
a data frame
}
\description{
This function collects tweets of a user or set of users between specified date ranges.
Tweet-level data is stored in a data/ path as a series of JSONs beginning "data_"; User-level
data is stored as a series of JSONs beginning "users_". If a filename is supplied, this
function will save the result as a RDS file, otherwise it will return the results as a dataframe.
}
\examples{
\dontrun{
bearer_token <- "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
users <- c("uoessps", "spsgradschool")
get_user_tweets(users, "2020-01-01T00:00:00Z", "2020-01-05T00:00:00Z", 
                bearer_token, data_path = "data/")
}
}
