% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rle2.R
\name{rle2}
\alias{rle2}
\title{Run Length Encoding (Alternate Implementation)}
\usage{
rle2(x, class = NULL, indices = FALSE)
}
\arguments{
\item{x}{Vector (see \code{class}).}

\item{class}{Character string specifying class of \code{x}. If unspecified, 
function figures it out (at cost of slightly slower run time).}

\item{indices}{Logical value for whether to record start/stop positions in 
addition to values and lengths for each run.}
}
\value{
Integer or numeric matrix.
}
\description{
Summarizes vector containing runs of repeated values. Very similar to 
\code{\link[base]{rle}}, but sometimes much faster, and with an option to 
return the start/end indices for each run.
}
\examples{
# Create dummie vector x
x <- c(0, 0, 0, -1, -1, 10, 10, 4, 6, 6)

# Summarize x using rle2
x.summarized <- rle2(x)

# Repeat, but also record start/stop indices for each run
x.summarized <- rle2(x = x, indices = TRUE)


}
