% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acled_access.R
\name{acled_access}
\alias{acled_access}
\title{Store your ACLED access information into your session.}
\usage{
acled_access(email, key)
}
\arguments{
\item{email}{This is the email that you register in the ACLED Access portal (https://developer.acleddata.com/)}

\item{key}{This is the key generated by the ACLED Access portal.}
}
\value{
Returns a success message if ACLED credentials are successfully authorized
}
\description{
Simple function to authenticate and store (through \code{Sys.setenv()}) ACLED access key for the acled_api() function. If email and key is stored via acled_access, the email and key arguments for acled_api can be NULL.
}
\examples{
\dontrun{
acled_access(email = "your_email", key = "your_key")
Sys.getenv("acled_email")
Sys.getenv("acled_key")
}
}
\seealso{
ACLED API Access guide \url{https://acleddata.com/download/35300/}

Other API and Access: 
\code{\link{acled_api}()},
\code{\link{acled_deletions_api}()},
\code{\link{acled_update}()}
}
\concept{API and Access}
