% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcripts_add.R
\name{transcripts_add}
\alias{transcripts_add}
\title{Add transcripts to a corpus}
\usage{
transcripts_add(
  x,
  ...,
  skipDuplicates = FALSE,
  createFullText = TRUE,
  assignMedia = TRUE
)
}
\arguments{
\item{x}{Corpus object}

\item{...}{transcript object, list of transcript objects, corpus object.}

\item{skipDuplicates}{Logical; If \code{FALSE} double transcripts will be renamed to make the names unique, if \code{TRUE} double transcripts will not be added.}

\item{createFullText}{Logical; if \code{TRUE} full text will be created.}

\item{assignMedia}{Logical; if \code{TRUE} the folder(s) specified in \code{@paths.media.files} of your corpus object will be scanned for media.}
}
\value{
Corpus object
}
\description{
Add a single or multiple transcript objects to a corpus object.
}
\details{
The name of the transcript objects have to be unique in the act package. 
The \code{@name} attribute of each transcript object will be set as identifier in the list of transcripts in the corpus object.
By default, transcripts with non unique names will be renamed. 
If you prefer to import.skip.double.files, set the parameter \code{skipDuplicates=TRUE}.
Skipped/renamed transcripts will be reported in
}
\examples{
library(act)

# get one of the already existing transcript in the examplecorpus
newtrans <- examplecorpus@transcripts[[1]]

# add this transcript to the examplecorpus
newcorpus <- act::transcripts_add(examplecorpus, newtrans)

# compare the two corpus objects
length(examplecorpus@transcripts)
length(newcorpus@transcripts)

names(examplecorpus@transcripts)
names(newcorpus@transcripts)
}
