% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_tiers_sort_table.R
\name{helper_tiers_sort_table}
\alias{helper_tiers_sort_table}
\title{Helper: Sort a tier table}
\usage{
helper_tiers_sort_table(
  tierTable,
  sortVector,
  addMissingTiers = TRUE,
  deleteTiersThatAreNotInTheSortVector = FALSE
)
}
\arguments{
\item{tierTable}{Data frame; tiers as specified and necessary in \code{@tiers} of a transcript object.}

\item{sortVector}{Vector of character strings; regular expressions to match the tier names. The order within the vector presents the new order of the tiers. Use "\\*" (=two backslashes and a star) to indicate where tiers that are not present in the sort vector but in the transcript should be inserted.}

\item{addMissingTiers}{Logical; if \code{TRUE} all tiers that are given in 'the 'sortVector' but are missing in 'tierTable' will be added.}

\item{deleteTiersThatAreNotInTheSortVector}{Logical; if \code{TRUE} tiers that are not matched by the regular expressions in 'sortVector' will be deleted. Otherwise the will be inserted at the end of the table or at the position defined by '"\\*' in  'sortVector.}
}
\value{
Data.frame
}
\description{
NOTE: To actually reorder the tiers in a transcript object or a corpus object corpus use \code{act::tiers_sort}.
This function is only a helper function and for people that like experiments.
}
\details{
Sort a tier table by a predefined vector of regular expression strings.
Tiers that are missing in the table but are present in the sort vector may be inserted.
Tiers that are present in the table but not in the sort vector may be deleted or inserted. These tiers will be inserted by default at the end of the table. You may also use a element '\\*' in  'sortVector' to define the position where they should be placed..
}
\examples{
# This function applies to the tier tables that are necessary in \code{@tiers} of a transcript.
# object. For clarity, we will create such a table from scratch.

library(act)

# --- Create a tier table from scratch
tierTable <- helper_tiers_new_table(c("a","b","c", "d"), 
c("IntervalTier", "TextTier","IntervalTier","TextTier"))

# --- Create a vector, defining the new order of the tiers.
sortVector <- c("c","a","d","b")

# Sort the table
tierTable.1 <- act::helper_tiers_sort_table(tierTable=tierTable, sortVector=sortVector)
tierTable.1

# --- Create a vector, in which the tier "c" is missing.
sortVector <- c("a","b","d")

# Sort the table, the missing tier will be inserted at the end.
tierTable.1 <- act::helper_tiers_sort_table(tierTable=tierTable, sortVector=sortVector)
tierTable.1

# --- Create a vector, in which the tier "c" is missing, 
# but define the place, where missing tiers will be inserted by "*"
sortVector <- c("a","\\\\*", "b","d")

# Sort the table. The missing tier "c" will be inserted in second place.
tierTable.2 <- act::helper_tiers_sort_table(tierTable=tierTable, sortVector=sortVector)
tierTable.2

# Sort the table, but delete tiers that are missing in the sort vector
# Note: If 'deleteTiersThatAreNotInTheSortVector=TRUE' tiers that are missing in the
# will be deleted, even if the 'sortVector' contains a "\\*".
tierTable.3 <- act::helper_tiers_sort_table(tierTable=tierTable, 
sortVector=sortVector, 
deleteTiersThatAreNotInTheSortVector=TRUE)
tierTable.3

# --- Create a vector, which contains tier names that are not present in 'tierTable'.
sortVector <- c("c","a","x", "y", "d","b")
tierTable.4 <- act::helper_tiers_sort_table(tierTable=tierTable, sortVector=sortVector)
tierTable.4

}
\seealso{
\link{tiers_sort}, \link{helper_tiers_new_table}, \link{helper_tiers_merge_tables}
}
