% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activity_code.r
\docType{class}
\name{actmod-class}
\alias{actmod-class}
\title{Activity model class.}
\description{
An S4 class describing activity models fitted to time of observation data.
}
\section{Slots}{

\describe{
\item{\code{data}}{Object of class \code{"numeric"}, the input data.}

\item{\code{wt}}{Object of class \code{"numeric"}, weights applied to the data.}

\item{\code{bw}}{Object of class \code{"numeric"}, kernel bandwidth.}

\item{\code{adj}}{Object of class \code{"numeric"}, kernel bandwidth adjustment multiplier.}

\item{\code{pdf}}{Object of class \code{"matrix"} describing fitted probability density function:
 Column 1: A regular sequence of radian times at which PDF evaluated; range is [0, 2*pi] if unbounded, and sequence steps are range difference divided by 512.
 Column 2: Corresponding circular kernel PDF values.
Additionally if errors bootstrapped:
 Column 3: PDF standard error.
 Column 4: PDF lower 95\% confidence limit. Column 5: PDF upper 95\% confidence limit.}

\item{\code{act}}{Object of class \code{"numeric"} giving activity level estimate and, if errors boostrapped, standard error and 95 percent confidence limits.}
}}

