% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GCMM.R
\name{GCMM}
\alias{GCMM}
\title{Generalized circular mixed effect mixture (GCMM) model}
\usage{
GCMM(
  data,
  RE1,
  RE2 = NULL,
  scale = "2pi",
  kmax = 15,
  family = c("vonmises", "wrappedcauchy"),
  autorun = TRUE,
  minESS = 5000,
  maxrep = 5,
  thin = 2,
  burnin = 5000,
  sample = 5000,
  adapt = 1000,
  n.chains = 3,
  saveREs = FALSE,
  saveResids = FALSE,
  saveclustIDs = FALSE,
  saveYExp = FALSE,
  saveJAGS = TRUE,
  Nclust = "NULL",
  clustmeans = NULL
)
}
\arguments{
\item{data}{Vector of observations in radians (0 to 2pi)}

\item{RE1}{Vector identifying random effect for observations (e.g. camera trap ID)}

\item{RE2}{Vector identifying second random effect for observations (e.g. study site, year, season, sampling period)}

\item{scale}{Scale of observations, either 0 to 2pi ("2pi") or -pi to pi ("pi")}

\item{kmax}{Maximum number to test for vonmises kappa parameter; default=15}

\item{family}{Probability distribution, either "vonmises" or "wrappedcauchy"}

\item{autorun}{Logical argument for whether to autmatically extend the analyses to achieve MCMC chain convergence and a specified minimum effective sample size (ESS) for all parameters; default=TRUE}

\item{minESS}{Minimum effective sample size (ESS) from the posterior distribution desired for all paramerers; default=5000, though a minimum ESS of 10000 is recommended}

\item{maxrep}{Maximum number of extensions of the analysis if \code{autorun=TRUE}; default=5}

\item{thin}{Thinning rate for MCMC chains, i.e. how many samples are saved. For longer models, thin can be increased to reduce computer memory requirements}

\item{burnin}{If autojags=FALSE, the burnin for the MCMC chains which are not saved; default=5000}

\item{sample}{If autojags=FALSE, the number of MCMC samples per chain (which is multiplied by thin); default=10000}

\item{adapt}{adaptation to use for MCMC chains; default=1000}

\item{n.chains}{number of MCMC chains; default=3}

\item{saveREs}{Whether random intercepts are saved in output; recommended to save only one of saveREs, saveResids or saveYExp at one time due to memory limitations}

\item{saveResids}{Whether model residuals are saved in output; recommended to save only one of saveREs, saveResids or saveYExp at one time due to memory limitations}

\item{saveclustIDs}{Whether to save component cluster identification for the data points; default=FALSE}

\item{saveYExp}{Whether expected Y values based on model are saved in output; recommended to save only one of saveREs, saveResids or saveYExp at one time due to memory limitations}

\item{saveJAGS}{Logical argument of whether to save runjags output; default=FALSE}

\item{Nclust}{Number of components for mixture models; if not provided, the function will estimate the number of clusters; if provided, values must be provided for clustmeans}

\item{clustmeans}{A vector equal in length to Nclust of the potential means for each component in the mixture models}
}
\value{
Returns object of class \code{GCMM} which is a list containing analysis results and details. A plot of the estimated activity curve from the mixed effect mixture model is printed.

\code{output} GCMM model output summary

\code{GCMMmixture} Vectors of simulated values from mixture model

\code{GCMMcomponents} Vectors of simulated values from each component in the mixture model

\code{runjags} GCMM model output from JAGS of class \code{runjags} from \code{runjags} package; see \code{\link[runjags]{run.jags}}
}
\description{
Bayesian parametric generalized circular mixed effect mixture models (GCMM) for estimating animal activity curves
from camera traps and other nested data structures using JAGS. Data distributions currently supported include
von Mises and wrapped Cauchy, with one or two random effects fit as random circular intercepts. The GCMM function
automatically selects the number of components for the mixture model (supporting up to 4 mixture components)
and runs the model in 'JAGS' through R. The number of clusters can also be manually selected. The function
returns the model summary and the activity curve estimated from the circular mixture model, with additional
information from the analysis provided in the output as a list of class \code{GCMM}.

Package: activityGCMM
Version: 1.0.1
Date: 2021-06-06
Author: Liz AD Campbell
}
\details{
The number of clusters is automatically selected based on a Bayesian linear finite normal mixture model via
the \code{mclust} package. The Bayesian parametric GCMM is fit using 'JAGS' through R using the \code{runjags}
package.
}
\examples{
data(redfoxsample)
\donttest{ FoxActivityGCMM<-GCMM(data=redfoxsample$Radians, RE1=redfoxsample$SamplingPeriod, 
    scale=c("2pi"), family="vonmises", autorun=FALSE,
    adapt=0, sample=300, burnin=300, thin=1,n.chains=2  ) }
 
}
\author{
Liz AD Campbell
}
\keyword{Bayesian}
\keyword{activity;}
\keyword{cameratrap;}
\keyword{circular;}
\keyword{mixture;}
\keyword{temporal;}
\keyword{vonmises;}
\keyword{wrappedcauchy;}
