% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hierCredibility.R
\name{hierCredibility}
\alias{hierCredibility}
\title{Hierarchical credibility model of Jewell}
\usage{
hierCredibility(
  Yijkt,
  wijkt,
  sector,
  group,
  data,
  muHat = NULL,
  type = c("additive", "multiplicative"),
  returnData = FALSE
)
}
\arguments{
\item{Yijkt}{variable name of the response variable (the loss cost within actuarial applications).}

\item{wijkt}{variable name of the exposure weight.}

\item{sector}{variable name of the first hierarchical level.}

\item{group}{variable name of the second hierarchical level that is nested within the first hierarchical level.}

\item{data}{an object that is coercible by \code{\link[data.table]{as.data.table}}, containing the variables in the model.}

\item{muHat}{estimate for the intercept term. Default is \code{NULL} and in this case, the estimator as given in Ohlsson (2005) is used.}

\item{type}{specifies whether the additive (Dannenburg, 1996) or multiplicative (Ohlsson, 2005) formulation of the hierarchical credibility model is used. Default is additive.}

\item{returnData}{Logical, indicates whether the data object has to be returned. Default is \code{FALSE}.}
}
\value{
An object of type \code{hierCredibility} with the following slots:

\item{call}{the matched call}

\item{type}{Whether additive or multiplicative hierarchical credibility model is used.}

\item{Variances}{The estimated variance components. \code{s2} is the estimated variance of the individual contracts,
 \code{tausq} the estimate of \eqn{Var(V[j])} and \code{nusq} is the estimate of \eqn{Var(V[jk])}.}

\item{Means}{The estimated averages at the portfolio level (intercept term \eqn{\mu}), at the first
hierarchical level (\eqn{bar(Y)[\%.\% j \%.\% \%.\%]^z}) and at the second hierarchical level (\eqn{bar(Y)[\%.\% jk \%.\%]}).}

\item{Weights}{The weights at the first hierarchical level \eqn{z[j\%.\%]} and at the second hierarchical level \eqn{w[\%.\%jk\%.\%]}.}

\item{Credibility}{The credibility weights at the first hierarchical level \eqn{q[j\%.\%]} and at the second hierarchical level \eqn{z[jk]}.}

\item{Premiums}{The overall expectation \eqn{widehat(\mu)}, sector expectation \eqn{widehat(V)[j]} and group expectation \eqn{widehat(V)[jk]}.}

\item{Relativity}{The estimated random effects \eqn{widehat(U)[j]} and \eqn{widehat(U)[jk]} of the sector and group, respectively.}

\item{RawResults}{Objects of type \code{data.table} with all intermediate results.}

\item{fitted.values}{the fitted mean values, resulting from the model fit.}
}
\description{
Fit a random effects model, without contract-specific risk factors,  using the hierarchical credibility model of Jewell.
}
\examples{
library(actuar)
library(actuaRE)
data("hachemeister", package = "actuar")
Df = as.data.frame(hachemeister)
X  = as.data.frame(cbind(cohort = c(1, 2, 1, 2, 2), hachemeister))
Df = reshape(X, idvar = "state", varying = list(paste0("ratio.", 1:12),
 paste0("weight.", 1:12)), direction = "long")
fitActuar  = cm(~ cohort + cohort:state, data = X, ratios = ratio.1:ratio.12,
weights = weight.1:weight.12, method = "Ohlsson")
fitActuaRE = hierCredibility(ratio.1, weight.1, cohort, state, Df)
summary(fitActuar)
summary(fitActuaRE)
}
\references{
Campo, B.D.C. and Antonio, Katrien (2023). Insurance pricing with hierarchically structured data an illustration with a workers' compensation insurance portfolio. \emph{Scandinavian Actuarial Journal}, doi: 10.1080/03461238.2022.2161413

Dannenburg, D. R., Kaas, R. and Goovaerts, M. J. (1996). \emph{Practical actuarial credibility models}. Amsterdam: IAE (Institute of Actuarial Science and Econometrics of the University of Amsterdam).

Jewell, W. S. (1975). \emph{The use of collateral data in credibility theory: a hierarchical model}. Laxenburg: IIASA.

Ohlsson, E. (2005). Simplified estimation of structure parameters in hierarchical credibility. \emph{Presented at the Zurich ASTIN Colloquium}.
}
\seealso{
\code{\link{hierCredibility-class}}, \code{\link{fitted.hierCredibility}}, \code{\link{predict.hierCredibility}}, \code{\link{ranef-actuaRE}},
 \code{\link{weights-actuaRE}}, \code{\link{hierCredTweedie}}, \code{\link{hierCredGLM}}, \code{\link[cplm]{cpglm}}, \code{\link{plotRE}}
}
