% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01genericSupport.r
\name{rawToAmigaInt}
\alias{rawToAmigaInt}
\title{Convert raw values into Amiga integers}
\usage{
rawToAmigaInt(x, bits = 8, signed = F)
}
\arguments{
\item{x}{A vector of class \code{raw} to be converted into a \code{character}.}

\item{bits}{Number of bits that represents the integer value. Should be 8 or a
positive multitude of 8.}

\item{signed}{A \code{logical} value indicating whether the integer
should be signed (\code{TRUE}, default) or not (\code{FALSE}).}
}
\value{
A \code{numeric} value (or a \code{vector} of values),
representing the integer data represented by the provided
\code{raw} data. Note that R defines \code{integer} as 32-bit
signed integers and cannot store the 32-bit signed values.
Therefore a \code{numeric} value is returned rather than an
explicit \code{integer}.
}
\description{
Convert raw data into 8, 16, or 32-bit signed or unsigned
integer values, conform Amiga specifications.
}
\details{
The Commodore Amiga has specified the following data formats
to represent integer data: BYTE (signed 8-bit integer), UBYTE
(unsigned 8-bit integer), WORD (signed 16-bit integer), UWORD
(unsigned 16-bit integer), LONG (signed 32-bit integer), ULONG,
(unsigned 32-bit integer). This function converts raw data into
such integers. Note that WORD and UWORD are also referred to as
SHORT and USHORT respectively.
}
\examples{
## Let's start by obtaining unsigned 8-bit integers:
rawToAmigaInt(as.raw(0:255))

## note that this is the same as:
as.numeric(as.raw(0:255))

## but with this function we can also get signed values:
rawToAmigaInt(as.raw(0:255), signed = TRUE)

## Furthermore 32 or 16-bit integers can also be obtained.
## Let's look at 16-bit integers:
rawToAmigaInt(as.raw(0:255), 16)

## Note that 16-bit integers require twice as many bytes
## as 8 bit integers:
length(rawToAmigaInt(as.raw(0:255), 16))
length(rawToAmigaInt(as.raw(0:255), 8))
}
\seealso{
Other raw.operations: \code{\link{amigaDateToRaw}},
  \code{\link{amigaIntToRaw}},
  \code{\link{displayRawData}},
  \code{\link{rawToAmigaDate}}
}
\author{
Pepijn de Vries
}
