% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_merged.R
\name{derive_vars_merged_dt}
\alias{derive_vars_merged_dt}
\title{Merge a (Imputed) Date Variable}
\usage{
derive_vars_merged_dt(
  dataset,
  dataset_add,
  by_vars,
  order = NULL,
  new_vars_prefix,
  filter_add = NULL,
  mode = NULL,
  dtc,
  date_imputation = NULL,
  flag_imputation = "auto",
  min_dates = NULL,
  max_dates = NULL,
  preserve = FALSE,
  check_type = "warning",
  duplicate_msg = NULL
)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by the \code{by_vars} parameter are expected.}

\item{dataset_add}{Additional dataset

The variables specified by the \code{by_vars}, the \code{dtc}, and the \code{order}
parameter are expected.}

\item{by_vars}{Grouping variables

The input dataset and the selected observations from the additional dataset
are merged by the specified by variables. The by variables must be a unique
key of the selected observations.

\emph{Permitted Values}: list of variables created by \code{vars()}}

\item{order}{Sort order

If the parameter is set to a non-null value, for each by group the first or
last observation from the additional dataset is selected with respect to
the specified order. The imputed date variable can be specified as well
(see examples below).

Please note that \code{NA} is considered as the last value. I.e., if a order
variable is \code{NA} and \code{mode = "last"}, this observation is chosen while for
\code{mode = "first"} the observation is chosen only if there are no
observations where the variable is not 'NA'.

\emph{Default}: \code{NULL}

\emph{Permitted Values}: list of variables or \verb{desc(<variable>)} function calls
created by \code{vars()}, e.g., \verb{vars(ADT, desc(AVAL)} or \code{NULL}}

\item{new_vars_prefix}{Prefix used for the output variable(s).

A character scalar is expected. For the date variable "DT" is appended to
the specified prefix and for the date imputation flag "DTF". I.e., for
\code{new_vars_prefix = "AST"} the variables \code{ASTDT} and \code{ASTDTF} are created.}

\item{filter_add}{Filter for additional dataset (\code{dataset_add})

Only observations fulfilling the specified condition are taken into account
for merging. If the parameter is not specified, all observations are
considered.

\emph{Default}: \code{NULL}

\emph{Permitted Values}: a condition}

\item{mode}{Selection mode

Determines if the first or last observation is selected. If the \code{order}
parameter is specified, \code{mode} must be non-null.

If the \code{order} parameter is not specified, the \code{mode} parameter is ignored.

\emph{Default}: \code{NULL}

\emph{Permitted Values}: \code{"first"}, \code{"last"}, \code{NULL}}

\item{dtc}{The \code{'--DTC'} date to impute

A character date is expected in a format like \code{yyyy-mm-dd} or
\code{yyyy-mm-ddThh:mm:ss}. If the year part is not recorded (missing date), no
imputation is performed.}

\item{date_imputation}{The value to impute the day/month when a datepart is
missing.

If \code{NULL}: no date imputation is performed and partial dates are returned as
missing.

Otherwise, a character value is expected, either as a
\itemize{
\item format with month and day specified as \code{"mm-dd"}: e.g. \code{"06-15"} for the 15th
of June,
\item or as a keyword: \code{"FIRST"}, \code{"MID"}, \code{"LAST"} to impute to the first/mid/last
day/month.
}

Default is \code{NULL}.}

\item{flag_imputation}{Whether the date imputation flag must also be derived.

If \code{"auto"} is specified, the date imputation flag is derived if the
\code{date_imputation} parameter is not null.

\emph{Default}: \code{"auto"}

\emph{Permitted Values}: \code{"auto"}, \code{"date"} or \code{"none"}}

\item{min_dates}{Minimum dates

A list of dates is expected. It is ensured that the imputed date is not
before any of the specified dates, e.g., that the imputed adverse event start
date is not before the first treatment date. Only dates which are in the
range of possible dates of the \code{dtc} value are considered. The possible dates
are defined by the missing parts of the \code{dtc} date (see example below). This
ensures that the non-missing parts of the \code{dtc} date are not changed.
A date or date-time object is expected.
For example

\if{html}{\out{<div class="sourceCode r">}}\preformatted{impute_dtc(
"2020-11",
min_dates = list(
 ymd_hms("2020-12-06T12:12:12"),
 ymd_hms("2020-11-11T11:11:11")
),
date_imputation = "first"
)
}\if{html}{\out{</div>}}

returns \code{"2020-11-11T11:11:11"} because the possible dates for \code{"2020-11"}
range from \code{"2020-11-01T00:00:00"} to \code{"2020-11-30T23:59:59"}. Therefore
\code{"2020-12-06T12:12:12"} is ignored. Returning \code{"2020-12-06T12:12:12"} would
have changed the month although it is not missing (in the \code{dtc} date).}

\item{max_dates}{Maximum dates

A list of dates is expected. It is ensured that the imputed date is not after
any of the specified dates, e.g., that the imputed date is not after the data
cut off date. Only dates which are in the range of possible dates are
considered. A date or date-time object is expected.}

\item{preserve}{Preserve day if month is missing and day is present

For example \code{"2019---07"} would return \verb{"2019-06-07} if \code{preserve = TRUE}
(and \code{date_imputation = "MID"}).

Permitted Values: \code{TRUE}, \code{FALSE}

Default: \code{FALSE}}

\item{check_type}{Check uniqueness?

If \code{"warning"} or \code{"error"} is specified, the specified message is issued
if the observations of the (restricted) additional dataset are not unique
with respect to the by variables and the order.

\emph{Default}: \code{"warning"}

\emph{Permitted Values}: \code{"none"}, \code{"warning"}, \code{"error"}}

\item{duplicate_msg}{Message of unique check

If the uniqueness check fails, the specified message is displayed.

\emph{Default}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{paste("Dataset `dataset_add` contains duplicate records with respect to",
      enumerate(vars2chr(by_vars)))
}\if{html}{\out{</div>}}}
}
\value{
The output dataset contains all observations and variables of the
input dataset and additionally the variable \verb{<new_vars_prefix>DT} and
optionally the variable \verb{<new_vars_prefix>DTF} derived from the additional
dataset (\code{dataset_add}).
}
\description{
Merge a imputed date variable and date imputation  flag from a dataset to the
input dataset. The observations to merge can be selected by a condition
and/or selecting the first or last observation for each by group.
}
\details{
\enumerate{
\item The additional dataset is restricted to the observations matching the
\code{filter_add} condition.
\item The date variable and if requested, the date imputation flag is added to
the additional dataset.
\item If \code{order} is specified, for each by group the first or last observation
(depending on \code{mode}) is selected.
\item The date and flag variables are merged to the input dataset.
}
}
\examples{
library(admiral.test)
library(dplyr, warn.conflicts = FALSE)
data("admiral_dm")
data("admiral_ex")

# derive treatment start date (TRTSDT)
derive_vars_merged_dt(
  select(admiral_dm, STUDYID, USUBJID),
  dataset_add = admiral_ex,
  by_vars = vars(STUDYID, USUBJID),
  new_vars_prefix = "TRTS",
  dtc = EXSTDTC,
  date_imputation = "first",
  order = vars(TRTSDT),
  mode = "first"
)

# derive treatment end date (TRTEDT) (without imputation)
derive_vars_merged_dt(
  select(admiral_dm, STUDYID, USUBJID),
  dataset_add = admiral_ex,
  by_vars = vars(STUDYID, USUBJID),
  new_vars_prefix = "TRTE",
  dtc = EXENDTC,
  order = vars(TRTEDT),
  mode = "last"
)
}
\author{
Stefan Bundfuss
}
\keyword{adam}
\keyword{derivation}
\keyword{timing}
