% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect_dfs_equal.R
\name{expect_dfs_equal}
\alias{expect_dfs_equal}
\title{Expectation: Are Two Datasets Equal?}
\usage{
expect_dfs_equal(base, compare, keys, ...)
}
\arguments{
\item{base}{Input dataset}

\item{compare}{Comparison dataset}

\item{keys}{\code{character} vector of variables that define a unique row in the
\code{base} and \code{compare} datasets}

\item{...}{Additional arguments passed onto \code{\link[diffdf:diffdf]{diffdf::diffdf()}}}
}
\value{
An error if \code{base} and \code{compare} do not match or \code{NULL} invisibly if they do
}
\description{
Uses \code{\link[diffdf:diffdf]{diffdf::diffdf()}} to compares 2 datasets for any differences. This function can be
thought of as an R-equivalent of SAS proc compare and a useful tool for unit testing as well.
}
\examples{
library(dplyr, warn.conflicts = FALSE)
library(tibble)

tbl1 <- tribble(
  ~USUBJID, ~AGE, ~SEX,
  "1001", 18, "M",
  "1002", 19, "F",
  "1003", 20, "M",
  "1004", 18, "F"
)

tbl2 <- tribble(
  ~USUBJID, ~AGE, ~SEX,
  "1001", 18, "M",
  "1002", 18.9, "F",
  "1003", 20, NA
)

try(expect_dfs_equal(tbl1, tbl2, keys = "USUBJID"))

tlb3 <- tribble(
  ~USUBJID, ~AGE, ~SEX,
  "1004", 18, "F",
  "1003", 20, "M",
  "1002", 19, "F",
  "1001", 18, "M",
)

# Note the sorting order of the keys is not required
expect_dfs_equal(tbl1, tlb3, keys = "USUBJID")

}
\author{
Thomas Neitmann
}
\concept{test_helper}
\keyword{test_helper}
