% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_unit}
\alias{assert_unit}
\title{Asserts That a Parameter is Provided in the Expected Unit}
\usage{
assert_unit(dataset, param, required_unit, get_unit_expr)
}
\arguments{
\item{dataset}{A \code{data.frame}}

\item{param}{Parameter code of the parameter to check}

\item{required_unit}{Expected unit}

\item{get_unit_expr}{Expression used to provide the unit of \code{param}}
}
\value{
The function throws an error if the unit variable differs from the
unit for any observation of the parameter in the input dataset. Otherwise, the
dataset is returned invisibly.
}
\description{
Checks if a parameter (\code{PARAMCD}) in a dataset is provided in the expected
unit.
}
\examples{
library(tibble)
advs <- tribble(
  ~USUBJID, ~VSTESTCD, ~VSTRESN, ~VSSTRESU, ~PARAMCD, ~AVAL,
  "P01",    "WEIGHT",      80.1, "kg",      "WEIGHT",  80.1,
  "P02",    "WEIGHT",      85.7, "kg",      "WEIGHT",  85.7
)

assert_unit(advs, param = "WEIGHT", required_unit = "kg", get_unit_expr = VSSTRESU)
}
\seealso{
Checks for valid input and returns warning or errors messages: 
\code{\link{assert_atomic_vector}()},
\code{\link{assert_character_scalar}()},
\code{\link{assert_character_vector}()},
\code{\link{assert_data_frame}()},
\code{\link{assert_date_vector}()},
\code{\link{assert_expr_list}()},
\code{\link{assert_expr}()},
\code{\link{assert_filter_cond}()},
\code{\link{assert_function_param}()},
\code{\link{assert_integer_scalar}()},
\code{\link{assert_list_element}()},
\code{\link{assert_list_of}()},
\code{\link{assert_logical_scalar}()},
\code{\link{assert_named}()},
\code{\link{assert_numeric_vector}()},
\code{\link{assert_one_to_one}()},
\code{\link{assert_param_does_not_exist}()},
\code{\link{assert_s3_class}()},
\code{\link{assert_same_type}()},
\code{\link{assert_symbol}()},
\code{\link{assert_vars}()},
\code{\link{assert_varval_list}()}
}
\concept{assertion}
\keyword{assertion}
