% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_advs_params.R
\name{derive_param_ratio}
\alias{derive_param_ratio}
\title{Adds a Ratio Parameter Computed from the Analysis Value of Other Parameters}
\usage{
derive_param_ratio(
  dataset,
  by_vars,
  numerator_code,
  denominator_code,
  set_values_to,
  constant_numerator = FALSE,
  constant_denominator = FALSE,
  filter = NULL,
  constant_by_vars = NULL,
  get_unit_expr = NULL,
  unit_conversion = FALSE
)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by the \code{by_vars} argument are expected to be in the dataset.
\code{PARAMCD}, and \code{AVAL} are expected as well.

The variable specified by \code{by_vars} and \code{PARAMCD} must be a unique key of the input dataset
after restricting it by the filter condition (\code{filter} argument) and to the parameters
specified by \code{numerator_code} and \code{denominator_code}.}

\item{by_vars}{Grouping variables

Grouping variables uniquely identifying a set of records for which
\code{new_vars} are to be calculated.

\emph{Permitted Values:} list of variables created by exprs()}

\item{numerator_code}{Numerator parameter code

The observations where \code{PARAMCD} equals the specified value are considered as the numerator.

\emph{Permitted Values:} character value}

\item{denominator_code}{Denominator parameter code

The observations where \code{PARAMCD} equals the specified value are considered as the denominator.

\emph{Permitted Values:} character value}

\item{set_values_to}{Variables to be set

The specified variables are set to the specified values for the new
observations. For example \code{exprs(PARAMCD = "RATIO")} defines the parameter code
for the new parameter.

\emph{Permitted Values:} List of variable-value pairs}

\item{constant_numerator}{Is numerator parameter constant?

It is expected that the parameter code (PARAMCD) specified in \code{numerator_code}
which is required to derive the new parameter is measured only once. For example,
if Height to Weight Ratio should be derived and height is measured only once while
Weight is measured at each visit. Height could be specified in the \code{numerator_code}
argument and \code{constant_numerator} is to be set to \code{TRUE}.

\emph{Permitted Values:} logical scalar}

\item{constant_denominator}{Is denominator parameter constant?

It is expected that the parameter code (PARAMCD) specified in \code{numerator_code}
which is required to derive the new parameter is measured only once. For example,
if Waist to Height Ratio should be derived and height is measured only once
while Waist Circumference is measured at each visit. Height could be specified in
the \code{denominator_code} argument and \code{constant_denominator} is to be set to \code{TRUE}.

\emph{Permitted Values:} logical scalar}

\item{filter}{Filter condition

The specified condition is applied to the input dataset before deriving the
new parameter, i.e., only observations fulfilling the condition are taken
into account.

\emph{Permitted Values:} a condition}

\item{constant_by_vars}{By variables for when numerator and/or denominator is constant

When numerator and/or denominator is constant, the parameters (measured only once) are merged
to the other parameters using the specified variables.

If numerator and/or denominator is constant (e.g. only measured once at screening or baseline)
then use \code{constant_by_vars} to select the subject-level variable to merge on (e.g. \code{USUBJID}).
This will produce a generic Ratio parameter at all visits where numerator and/or denominator
is measured. Otherwise it will only be calculated at visits with both numerator and denominator
parameters collected.

\emph{Permitted Values}: list of variables created by \code{exprs()}, e.g. \code{exprs(USUBJID, VISIT)}}

\item{get_unit_expr}{An expression providing the unit of the parameter

The result is used to check the units of the input parameters. If the units are not consistent
within each parameter, an error will be thrown.

Additionally, if the input parameters are measured in different units but are mutually
convertible (e.g., centimeters for one parameter and inches for another), an automatic
conversion will be performed in order to uniform the values before calculating the ratio.

\strong{Note:} Conversion factors come from unit definitions as per CDISC standards.
\if{html}{\out{<br/>}}\emph{m} is defined as 100 cm
\if{html}{\out{<br/>}}\emph{mm} is defined as 0.1 cm
\if{html}{\out{<br/>}}\emph{in} is defined as 2.54 cm
\if{html}{\out{<br/>}}\emph{ft} is defined as 30.48 cm

\emph{Permitted Values:} A variable of the input dataset or a function call}

\item{unit_conversion}{Enable/Disable unit conversion

Unit conversion is disabled by default. Ignored if \code{get_unit_expr} is \code{NULL}.

\emph{Permitted Values:} logical scalar}
}
\value{
The input dataset with the new parameter added. Note, a variable will only
be populated in the new parameter rows if it is specified in \code{by_vars}.
}
\description{
Adds a record for a generic Ratio parameter using two existing parameter
(numerator and denominator) each by group (e.g., subject and visit) where the source parameters
are available.

\strong{Note:} This is a wrapper function for the more generic \code{\link[admiral:derive_param_computed]{admiral::derive_param_computed()}}.
}
\details{
The analysis value of the new parameter is derived as
\deqn{RATIO = \frac{NUMERATOR}{DENOMINATOR}}
}
\seealso{
Other internal: 
\code{\link{admiralmetabolic-package}}
}
\concept{internal}
\keyword{internal}
