% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/propose.R
\docType{data}
\name{eight_leaves_trees}
\alias{eight_leaves_trees}
\title{Eight leaves trees.}
\format{A list of functions on eight leaves.
        The outputs of these functions are \code{\link{agraph}} objects.}
\usage{
eight_leaves_trees
}
\description{
A comprehensive listing of three unrooted trees with eight leaves.
The position of the root can be moved later with the function
\code{\link{make_an_outgroup}}.
}
\examples{
\donttest{
# While the usage of this function is pretty self-explanatory, let's plot all the graphs
# just for browsing.
for (i in seq(1, length(eight_leaves_trees))) {
  graph <- eight_leaves_trees[[i]](c("A", "B", "C", "D", "E", "F", "G", "H"))
  # This is how you include quotation marks in strings by the way:
  title <- paste("eight_leaves_trees[[", i,
                 "]](c(\\"A\\", \\"B\\", \\"C\\", \\"D\\", \\"E\\", \\"F\\", \\"G\\", \\"H\\"))", sep = "")
  plot(graph, color = "brown", title = title)
}
}

}
\seealso{
\code{\link{make_permutations}}

\code{\link{fit_permutations_and_graphs}}

\code{\link{add_a_leaf}}

\code{\link{add_an_admixture}}

\code{\link{add_an_admixture2}}

\code{\link{make_an_outgroup}}

Other graphs: \code{\link{five_leaves_graphs}},
  \code{\link{four_leaves_graphs}},
  \code{\link{seven_leaves_trees}},
  \code{\link{six_leaves_graphs}}
}
\keyword{datasets}

