% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConditionalPower.R
\docType{class}
\name{ConditionalPower-class}
\alias{ConditionalPower-class}
\alias{ConditionalPower}
\title{Conditional power of a design given stage-one outcome}
\usage{
ConditionalPower(dist, prior)
}
\arguments{
\item{dist}{a univariate \code{\link[=DataDistribution-class]{distribution}} object}

\item{prior}{a \code{\link{Prior}} object}
}
\description{
This score evaluates \ifelse{html}{\out{P[X<sub>2</sub> > c2(design, X<sub>1</sub>) | X<sub>1</sub> = x<sub>1</sub>]}}{\eqn{\boldsymbol{P}[X_2 > c_2(design, X_1)|X_1 = x_1]}}.
Note that the distribution of \ifelse{html}{\out{X<sub>2</sub>}}{\eqn{X_2}} is the posterior predictive after
observing \ifelse{html}{\out{X<sub>1</sub> = x<sub>1</sub>}}{\eqn{X_1 = x_1}}.
}
\examples{
cp <- ConditionalPower(dist = Normal(), prior = PointMassPrior(.4, 1))

}
\seealso{
The method \code{\link{evaluate}} provides evaluation of the
   \code{ConditionalPower}.
}
