% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TwoStageDesign.R, R/OneStageDesign.R
\name{c2}
\alias{c2}
\alias{c2,TwoStageDesign,numeric-method}
\alias{c2,OneStageDesign,numeric-method}
\title{Query critical values of a design}
\usage{
c2(d, x1, ...)

\S4method{c2}{TwoStageDesign,numeric}(d, x1, ...)

\S4method{c2}{OneStageDesign,numeric}(d, x1, ...)
}
\arguments{
\item{d}{design}

\item{x1}{stage-one test statistic}

\item{...}{further optional arguments}
}
\value{
the critical value function \code{c2} of design \code{d} at position \code{x1}
}
\description{
Methods to access the stage-two critical values of a
\code{\link{TwoStageDesign}}.
\code{c2} returns the stage-two critical value conditional on the stage-one test
statistic.
}
\examples{
design <- TwoStageDesign(
  n1    = 25,
  c1f   = 0,
  c1e   = 2.5,
  n2    = 50,
  c2    = 1.96,
  order = 7L
)

c2(design, 2.2) # 1.96
c2(design, 3.0) # -Inf
c2(design, -1.0) # Inf

design <- TwoStageDesign(
   n1    = 25,
   c1f   = 0,
   c1e   = 2.5,
   n2    = 50,
   c2    = 1.96,
   order = 7L
)

c2(design, 2.2) # 1.96
c2(design, 3.0) # -Inf
c2(design, -1.0) # Inf

}
\seealso{
\code{\link{TwoStageDesign}}, see \code{\link{n}} for accessing
the sample size of a design
}
