% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minimize.R
\name{get_initial_design}
\alias{get_initial_design}
\title{Initial design}
\usage{
get_initial_design(
  theta,
  alpha,
  beta,
  type = c("two-stage", "group-sequential", "one-stage"),
  dist = Normal(),
  order = 7L,
  ...
)
}
\arguments{
\item{theta}{the alternative effect size in the normal case, the
rate difference under the alternative in the binomial case}

\item{alpha}{maximal type I error rate}

\item{beta}{maximale type II error rate}

\item{type}{is a two-stage, group-sequential, or one-stage design requried?}

\item{dist}{distribution of the test statistic}

\item{order}{desired integration order}

\item{...}{further optional arguments}
}
\value{
An object of class \code{\link{TwoStageDesign}}.
}
\description{
The optimization method \code{\link{minimize}} requires an initial
design for optimization.
The function \code{get_initial_design} provides an initial guess based on a
fixed design that fulfills constraints on type I error rate and power.
Note that a situation-specific initial design may be much more efficient.
}
\details{
The distribution of the test statistic is specified by \code{dist}.
The default assumes a two-armed z-test.
}
\examples{
init <- get_initial_design(
   theta = 0.3,
   alpha = 0.025,
   beta  = 0.2,
   type  = "two-stage",
   dist  = Normal(two_armed = FALSE),
   order = 7L
)

}
