% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nll_poisson_gamma.R
\name{nll_poisson_gamma}
\alias{nll_poisson_gamma}
\title{Negative Log-Likelihood for Poisson Gamma Model}
\usage{
nll_poisson_gamma(theta, data, formula)
}
\arguments{
\item{theta}{A numeric vector containing model parameters. The first part of
the vector represents fixed effects, and the remaining part represents model
parameters.}

\item{data}{A tibble containing the time series data, including columns 'y'
for observed values,'n' for population size, and other covariates of
interest.}

\item{formula}{A formula specifying the model structure.}
}
\value{
The negative log-likelihood value.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Calculate the negative log-likelihood for the Poisson Gamma modeling
framework.
}
\examples{
# Initial parameters
theta <- c(0.5, 0.1)

# Sample data
data <- data.frame(
  y = c(10, 15, 20, 30, 50, 100, 200, 40, 20, 10),
  n = c(100, 150, 200, 300, 500, 1000, 2000, 400, 200, 100)
)

# Fixed effects model formula
fixed_effects_formula <- y ~ 1

# Calculate negative log likelihood
nll_poisson_gamma(
  theta = theta,
  data = data,
  formula = fixed_effects_formula
)
}
