% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzylogic-implication.R
\name{fimplication_minimal}
\alias{fimplication_minimal}
\alias{fimplication_maximal}
\alias{fimplication_kleene}
\alias{fimplication_lukasiewicz}
\alias{fimplication_reichenbach}
\alias{fimplication_fodor}
\alias{fimplication_goguen}
\alias{fimplication_goedel}
\alias{fimplication_rescher}
\alias{fimplication_weber}
\alias{fimplication_yager}
\title{Fuzzy Implications}
\usage{
fimplication_minimal(x, y)

fimplication_maximal(x, y)

fimplication_kleene(x, y)

fimplication_lukasiewicz(x, y)

fimplication_reichenbach(x, y)

fimplication_fodor(x, y)

fimplication_goguen(x, y)

fimplication_goedel(x, y)

fimplication_rescher(x, y)

fimplication_weber(x, y)

fimplication_yager(x, y)
}
\arguments{
\item{x}{numeric vector with elements in \eqn{[0,1]}}

\item{y}{numeric vector of the same length as \code{x},
with elements in \eqn{[0,1]}}
}
\value{
Numeric vector of the same length as \code{x} and \code{y}.
The \code{i}th element of the resulting vector gives the result
of calculating \code{I(x[i], y[i])}.
}
\description{
Various fuzzy implications
Each of these is a fuzzy logic generalization
of the classical implication operation.
}
\details{
A function \eqn{I: [0,1]\times [0,1]\to [0,1]}
is a \emph{fuzzy implication} if for all \eqn{x,y,x',y'\in [0,1]} it holds:
(a) if \eqn{x\le x'}, then \eqn{I(x, y)\ge I(x', y)};
(b) if \eqn{y\le y'}, then \eqn{I(x, y)\le I(x, y')};
(c) \eqn{I(1, 1)=1};
(d) \eqn{I(0, 0)=1};
(e) \eqn{I(1, 0)=0}.

The minimal fuzzy implication is given by \eqn{I_0(x, y)=1}
iff \eqn{x=0} or \eqn{y=1}, and 0 otherwise.

The maximal fuzzy implication is given by \eqn{I_1(x, y)=0}
iff \eqn{x=1} and \eqn{y=0}, and 1 otherwise.

The Kleene-Dienes fuzzy implication is given by \eqn{I_{KD}(x, y)=max(1-x, y)}.

The Lukasiewicz fuzzy implication is given by \eqn{I_{L}(x, y)=min(1-x+y, 1)}.

The Reichenbach fuzzy implication is given by \eqn{I_{RB}(x, y)=1-x+xy}.

The Fodor fuzzy implication is given by \eqn{I_F(x, y)=1}
iff \eqn{x\le y}, and \eqn{max(1-x, y)} otherwise.

The Goguen fuzzy implication is given by \eqn{I_{GG}(x, y)=1}
iff \eqn{x\le y}, and \eqn{y/x} otherwise.

The Goedel fuzzy implication is given by \eqn{I_{GD}(x, y)=1}
iff \eqn{x\le y}, and \eqn{y} otherwise.

The Rescher fuzzy implication is given by \eqn{I_{RS}(x, y)=1}
iff \eqn{x\le y}, and \eqn{0} otherwise.

The Weber fuzzy implication is given by \eqn{I_{W}(x, y)=1}
iff \eqn{x<1}, and \eqn{y} otherwise.

The Yager fuzzy implication is given by \eqn{I_{Y}(x, y)=1}
iff \eqn{x=0} and \eqn{y=0}, and \eqn{y^x} otherwise.
}
\references{
Klir G.J, Yuan B., \emph{Fuzzy sets and fuzzy logic. Theory and applications},
Prentice Hall PTR, New Jersey, 1995.

Gagolewski M., Data Fusion: Theory, Methods, and Applications,
   Institute of Computer Science, Polish Academy of Sciences, 2015, 290 pp.
   isbn:978-83-63159-20-7
}
\seealso{
Other fuzzy_logic: \code{\link{fnegation_yager}},
  \code{\link{tconorm_minimum}},
  \code{\link{tnorm_minimum}}
}
\concept{fuzzy_logic}
