\name{bar.err}
\alias{bar.err}
%- bar.err.
\title{ Plot of multiple comparison of means with standard error or deviance}
\description{
 Plots bars of the averages of treatments and standard error or standad 
 deviation. It uses the objects generated by a procedure of comparison like LSD,
 HSD, Kruskall and Waller-Duncan. 
 }
\usage{
bar.err(x, std = TRUE, horiz = FALSE, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{ object or comparisons the LSD.group, HSD.group,...,etc }
  \item{std}{ Standard deviation or standar error }
  \item{horiz}{ Horizontal or vertical bars }
  \item{\dots}{ Parameters of the function barplot()}
}
\details{
  x: data frame formed by 5 columns: name of the bars, height, level
  replications and standard error of the bar.
  std = T : standard deviation.
  std = F : standard error.
}
\value{
  \item{x}{ object  }
  \item{std}{ TRUE or FALSE }
  \item{horiz}{ TRUE or FALSE }
  \item{\dots}{ Parameters of the function barplot()}
}

\author{ Felipe de Mendiburu }

\seealso{\code{\link{LSD.group}}, \code{\link{HSD.group}}, \code{\link{waller.group}}, 
\code{\link{kruskal.group}}, \code{\link{bar.group}} }

\examples{
library(agricolae)
data(sweetpotato)
attach(sweetpotato)
model<-aov(yield~virus)
df<-df.residual(model)
MSerror<-deviance(model)/df
Fc<-anova(model)[1,4]
comparison <- waller.group(yield,virus,df,MSerror,Fc,main="Yield of sweetpotato\ndealt with different virus")
# std = F (default) is standard error 
#startgraph
par(mfrow=c(2,2))
par(cex=1)
bar.err(comparison,horiz=TRUE,xlim=c(0,45),angle=125,density=6,main="Standard deviation")
bar.err(comparison,std=FALSE,horiz=TRUE,xlim=c(0,45),density=8,col="brown",main="Standard error")
bar.err(comparison,ylim=c(0,45),density=4,angle=125,col="green",main="Standard deviation")
bar.err(comparison,std=FALSE,ylim=c(0,45),density=10,col="blue",,main="Standard error")
#endgraph
}
\keyword{ aplot }% at least one, from doc/KEYWORDS

