% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ehe.R
\name{ehe}
\alias{ehe}
\title{Extreme Heat Exposure (EHE)}
\usage{
ehe(mx, dates, op = "first")
}
\arguments{
\item{mx}{vector of daily maximum temperature series.}

\item{dates}{vector of dates corresponding with daily temprature series}

\item{op}{character. Indicates whether the output will be in date or numeric format.}
}
\value{
If op = "first", the function returns the first day (date format) when the first event is triggered. If op =='doy', julian day is returned. If op = "number", the funciton returns the number of events occurred in the year.
}
\description{
Extreme Heat Exposure (EHE). Useful for climatic risks assessement on wheat and barley.
}
\details{
Adapted from Trnka et al. (2014). Event is triggered when the Tmax is above +35°C for at least three days during the period from five days after anthesis (supposed to be May-1st) to maturity (suposed to be July-31st). The minimum daily temperature is usually measured 2 m above ground; thus, the actual crop temperature might be even lower.
}
\examples{

            ehe(mx = daily_tmax,
            dates = seq.Date(as.Date('1981-01-01'),
                    as.Date('2010-12-31'), by ='day'),
            op = 'first')

}
\references{
Trnka M, Rotter RP, Ruiz-Ramos M, Kersebaum KC, Olesen JE, Zalud Z, Semenov MA (2014) Adverse weather conditions for European wheat production will become more frequent with climate change. Nature Climate Change volume 4, pages 637–643.
}
