% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{as_h2o}
\alias{as_h2o}
\alias{as_tibble.H2OFrame}
\title{Data conversion tools}
\usage{
as_h2o(df, destination_frame_prefix = "object")

\method{as_tibble}{H2OFrame}(
  x,
  ...,
  .rows = NULL,
  .name_repair = c("check_unique", "unique", "universal", "minimal"),
  rownames = pkgconfig::get_config("tibble::rownames", NULL)
)
}
\arguments{
\item{df}{A R data frame.}

\item{destination_frame_prefix}{A character string to use as the base name.}

\item{x}{An H2OFrame.}

\item{...}{Unused, for extensibility.}

\item{.rows}{The number of rows, useful to create a 0-column tibble or
just as an additional check.}

\item{.name_repair}{Treatment of problematic column names:
\itemize{
\item \code{"minimal"}: No name repair or checks, beyond basic existence,
\item \code{"unique"}: Make sure names are unique and not empty,
\item \code{"check_unique"}: (default value), no name repair, but check they are
\code{unique},
\item \code{"universal"}: Make the names \code{unique} and syntactic
\item a function: apply custom name repair (e.g., \code{.name_repair = make.names}
for names in the style of base R).
\item A purrr-style anonymous function, see \code{\link[rlang:as_function]{rlang::as_function()}}
}

This argument is passed on as \code{repair} to \code{\link[vctrs:vec_as_names]{vctrs::vec_as_names()}}.
See there for more details on these terms and the strategies used
to enforce them.}

\item{rownames}{How to treat existing row names of a data frame or matrix:
\itemize{
\item \code{NULL}: remove row names. This is the default.
\item \code{NA}: keep row names.
\item A string: the name of a new column. Existing rownames are transferred
into this column and the \code{row.names} attribute is deleted.
Read more in \link[tibble]{rownames}.
}}
}
\value{
A tibble or, for \code{as_h2o()}, a list with \code{data} (an H2OFrame) and
\code{id} (the id on the h2o server).
}
\description{
Data conversion tools
}
\examples{

# start with h2o::h2o.init()
if (h2o_running()) {
 cars2 <- as_h2o(mtcars)
 cars2
 class(cars2$data)

 cars0 <- as_tibble(cars2$data)
 cars0
}
}
