% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_fct.R
\name{get_synthetic_cases}
\alias{get_synthetic_cases}
\title{Create synthetic cases for balancing training data}
\usage{
get_synthetic_cases(
  embedding,
  times,
  features,
  target,
  method = c("smote"),
  max_k = 6
)
}
\arguments{
\item{embedding}{Named \code{data.frame} containing the text embeddings.
In most cases, this object is taken from \link{EmbeddedText}$embeddings.}

\item{times}{\code{int} for the number of sequences/times.}

\item{features}{\code{int} for the number of features within each sequence.}

\item{target}{Named \code{factor} containing the labels of the corresponding embeddings.}

\item{method}{\code{vector} containing strings of the requested methods for generating new cases.
Currently "smote","dbsmote", and "adas" from the package smotefamily are available.}

\item{max_k}{\code{int} The maximum number of nearest neighbors during sampling process.}
}
\value{
\code{list} with the following components.
\itemize{
\item{\code{syntetic_embeddings: }Named \code{data.frame} containing the text embeddings of
the synthetic cases.}

\item{\code{syntetic_targets }Named \code{factor} containing the labels of the corresponding
synthetic cases.}

\item{\code{n_syntetic_units }\code{table} showing the number of synthetic cases for every
label/category.}
}
}
\description{
This function creates synthetic cases for balancing the training with an
object of the class \link{TextEmbeddingClassifierNeuralNet}.
}
\seealso{
Other Auxiliary Functions: 
\code{\link{array_to_matrix}()},
\code{\link{calc_standard_classification_measures}()},
\code{\link{check_embedding_models}()},
\code{\link{create_iota2_mean_object}()},
\code{\link{create_synthetic_units}()},
\code{\link{generate_id}()},
\code{\link{get_coder_metrics}()},
\code{\link{get_folds}()},
\code{\link{get_n_chunks}()},
\code{\link{get_stratified_train_test_split}()},
\code{\link{get_train_test_split}()},
\code{\link{matrix_to_array_c}()},
\code{\link{split_labeled_unlabeled}()},
\code{\link{summarize_tracked_sustainability}()},
\code{\link{to_categorical_c}()}
}
\concept{Auxiliary Functions}
