% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_DataManager.R
\name{get_synthetic_cases_from_matrix}
\alias{get_synthetic_cases_from_matrix}
\title{Create synthetic cases for balancing training data}
\usage{
get_synthetic_cases_from_matrix(
  matrix_form,
  times,
  features,
  target,
  sequence_length,
  method = c("smote"),
  min_k = 1,
  max_k = 6
)
}
\arguments{
\item{matrix_form}{Named \code{matrix} containing the text embeddings in a matrix form.}

\item{times}{\code{int} for the number of sequences/times.}

\item{features}{\code{int} for the number of features within each sequence.}

\item{target}{Named \code{factor} containing the labels of the corresponding embeddings.}

\item{sequence_length}{\code{int} Length of the text embedding sequences.}

\item{method}{\code{vector} containing strings of the requested methods for generating new cases. Currently "smote",
"dbsmote", and "adas" from the package smotefamily are available.}

\item{min_k}{\code{int} The minimal number of nearest neighbors during sampling process.}

\item{max_k}{\code{int} The maximum number of nearest neighbors during sampling process.}
}
\value{
\code{list} with the following components:
\itemize{
\item \code{syntetic_embeddings}: Named \code{data.frame} containing the text embeddings of the synthetic cases.
\item \code{syntetic_targets}: Named \code{factor} containing the labels of the corresponding synthetic cases.
\item \code{n_syntetic_units}: \code{table} showing the number of synthetic cases for every label/category.
}
}
\description{
This function creates synthetic cases for balancing the training with an object of the class
\link{TEClassifierRegular} or \link{TEClassifierProtoNet}.
}
\seealso{
Other data_management_utils: 
\code{\link{create_synthetic_units_from_matrix}()},
\code{\link{get_n_chunks}()}
}
\concept{data_management_utils}
