% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_utility.R
\name{PlotUtilityDiffCI}
\alias{PlotUtilityDiffCI}
\title{Plot utility difference with 95\% confidence interval}
\usage{
PlotUtilityDiffCI(res)
}
\arguments{
\item{res}{The second data frame (res.mcmc) generated from \code{CalUtilityDiff(include.utility.diff.mcmc = TRUE)}.}
}
\value{
A ggplot.
}
\description{
See Figure S17 for example.
}
\examples{
\donttest{
data(synth)
sample_mcmc = AiEvalmcmc(data = synth, n.mcmc = 10)
synth_dmf = sample(0:1, nrow(synth), replace = TRUE) # random dmf recommendation
sample_utility = CalOptimalDecision(data = synth, mcmc.re = sample_mcmc, 
                                    c0.ls = seq(0,5,1), c1.ls = seq(0,5,1), 
                                    dmf = synth_dmf, size = 1, # adjust the size
                                    include.utility.diff.mcmc = TRUE)
PlotUtilityDiffCI(sample_utility$res.mcmc)
}

}
