% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/time.R
\docType{methods}
\name{span}
\alias{span}
\alias{span-method}
\alias{span,TimeSeries-method}
\title{Duration of Time Series}
\usage{
span(x, ...)

\S4method{span}{TimeSeries}(x, calendar = NULL)
}
\arguments{
\item{x}{A \code{\linkS4class{TimeSeries}} object.}

\item{...}{Currently not used.}

\item{calendar}{A \code{\linkS4class{TimeScale}} object specifying the target calendar
(see \code{\link[=calendar]{calendar()}}). If \code{NULL} (the default), \emph{rata die} are returned.}
}
\value{
A \code{\link{numeric}} vector.
}
\description{
Get the duration.
}
\examples{
## Create time-series of 20 observations

## Univariate
## Sampled every years starting from 1029 BCE
(X <- series(rnorm(30), time = 1029:1000, calendar = BCE()))

## Terminal and sampling times (returns rata die)
start(X)
end(X)
time(X)
span(X)

## Multivariate
## Sampled every century starting from 1000 CE
(Y <- series(matrix(rnorm(90), 30, 3), time = 1000:1029, calendar = CE()))

## Terminal and sampling times (returns Gregorian Common Era years)
start(Y, calendar = CE())
end(Y, calendar = CE())
time(Y, calendar = CE())
span(Y, calendar = CE())

## Coerce to data frame
df <- as.data.frame(Y, calendar = BP())
head(df)
}
\seealso{
Other time series tools: 
\code{\link{data.frame}},
\code{\link{series}()},
\code{\link{start}()},
\code{\link{time}()},
\code{\link{window}()}
}
\author{
N. Frerebeau
}
\concept{time series tools}
