% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Classes.R
\docType{class}
\name{MRCATest-class}
\alias{MRCATest-class}
\alias{MRCATest}
\alias{print,MRCATest-method}
\alias{MRCATest-method}
\alias{plot,MRCATest,missing-method}
\alias{MRCATest-method}
\title{S4 class defining edge significance}
\usage{
\S4method{print}{MRCATest}(x)

\S4method{plot}{MRCATest,missing}(x, y, ...)
}
\arguments{
\item{x}{MRCATest object.}

\item{y}{ignored.}

\item{...}{arguments to pass to \link{plotMRCATest}.}
}
\description{
\code{MRCATest} defines the significance of enrichment for annotations appearing at
the MRCA of the tree.
}
\section{Slots}{

\describe{
\item{\code{tests}}{data.frame describing the significance test results with columns:
\itemize{
  \item  \code{ANNOTATION}:  annotation value.
  \item  \code{COUNT}:       observed count of MRCA positions 
                             with the given annotation.
  \item  \code{EXPECTED}:    expected mean count of MRCA occurance
                             for the annotation.
  \item  \code{PVALUE}:      one-sided p-value for the hypothesis that 
                             the observed annotation abundance is greater 
                             than expected.
}}

\item{\code{permutations}}{data.frame containing the raw permutation test data with columns:
\itemize{
  \item  \code{ANNOTATION}:  annotation value.
  \item  \code{COUNT}:       count of MRCA positions with the 
                             given annotation.
  \item  \code{ITER}:        numerical index define which 
                             permutation realization each 
                             observation corresponds to.
}}

\item{\code{nperm}}{number of permutation realizations.}
}}

