% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PointMap.R
\docType{methods}
\name{unlinkRefs,PointMap-method}
\alias{unlinkRefs,PointMap-method}
\title{Unlink two PointMap Cells (refs)}
\usage{
\S4method{unlinkRefs}{PointMap}(map, fromRef, toRef)
}
\arguments{
\item{map}{A PointMap}

\item{fromRef}{Ref of the first unlink line}

\item{toRef}{Ref of the second unlink line}
}
\value{
None
}
\description{
Unlink two cells on an PointMap using their refs
}
\examples{
mifFile <- system.file(
    "extdata", "testdata", "gallery",
    "gallery_lines.mif",
    package = "alcyon"
  )
  sfMap <- st_read(mifFile,
    geometry_column = 1L, quiet = TRUE
  )
  pointMap <- makeVGAPointMap(
    sfMap,
    gridSize = 0.04,
    fillX = 3.01,
    fillY = 6.7,
    maxVisibility = NA,
    boundaryGraph = FALSE,
    verbose = FALSE
  )
linkRefs(pointMap, 1835056L, 7208971L)
unlinkRefs(pointMap, 1835056L, 7208971L)
}
