% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traits_to_mfg.R
\name{traits_to_mfg}
\alias{traits_to_mfg}
\title{Assign MFG based on binary functional traits and taxonomy (Class and Order)}
\usage{
traits_to_mfg(flagella = NA, size = NA, colonial = NA,
  filament = NA, centric = NA, gelatinous = NA, aerotopes = NA,
  class = NA, order = NA)
}
\arguments{
\item{flagella}{1 if flagella are present, 0 if they are absent.}

\item{size}{Character string: 'large' or 'small'. Classification criteria is left to the user.}

\item{colonial}{1 if typically colonial growth form, 0 if typically unicellular.}

\item{filament}{1 if dominant growth form is filamentous, 0 if not.}

\item{centric}{1 if diatom with centric growth form, 0 if not. NA for  non-diatoms.}

\item{gelatinous}{1 mucilagenous sheath is typically present, 0 if not.}

\item{aerotopes}{1 if aerotopes allowing buoyancy regulation are typically present, 0 if not.}

\item{class}{Character string: The taxonomic class of the species}

\item{order}{Character string: The taxonomic order of the species}
}
\value{
A character string of the species' morphofunctional group
}
\description{
Assign MFG based on binary functional traits and taxonomy (Class and Order)
}
\examples{
traits_to_mfg(flagella = 1,size = "large",colonial = 1,filament = 0,centric = NA,gelatinous = 0,
               aerotopes = 0,class = "Euglenophyceae",order = "Euglenales")
}
