% Generated by roxygen2 (4.0.2): do not edit by hand
\name{hmat}
\alias{hmat}
\title{Construct a Hierarchical Model Matrix}
\usage{
hmat(varlvls, facets)
}
\arguments{
\item{varlvls}{a vector containing the number of levels of each variable}

\item{facets}{the facets generating the hierarchical model, a list of vectors of variable indices}
}
\value{
a named matrix
}
\description{
Determine the A matrix associated with a hierarchical model on a contingency table.  In algebraic statistics, the A matrix of a log-linear model is the transpose of the design matrix of the (cell-means parameterized) ANOVA corresponding to the model.
}
\examples{
# LAS example 1.2.11, p.16
varlvls <- c(2,2,2,2)
facets <- list(c(1,2), c(1,4), c(2,3))
( A <- hmat(varlvls, facets) )

# 2x2 independence example
# following convention, the first index indicates rows
varlvls <- c(2,2)
facets <- list(1,2)
( A <- hmat(varlvls, facets) )

printForMarkov <- function(A){
  cat(paste(nrow(A), ncol(A)))
  cat("\\n")
  cat(apply(unname(A), 1, paste, collapse = " "), sep = "\\n")
  cat("\\n")
}
printForMarkov(A)
}
\references{
Drton, M., B. Sturmfels, and S. Sullivant (2009). \emph{Lectures on Algebraic Statistics}, Basel: Birkhauser Verlag AG.
}

