% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-contributors.R
\name{add_contributors}
\alias{add_contributors}
\title{add_contributors}
\usage{
add_contributors(
  repo = ".",
  ncols = 7,
  files = c("README.Rmd", "README.md"),
  type = c("code", "issues", "discussion"),
  exclude_label = "wontfix",
  exclude_issues = NULL,
  exclude_not_planned = TRUE,
  num_sections = 3,
  section_names = c("Code", "Issue Authors", "Issue Contributors"),
  format = "grid",
  alphabetical = FALSE,
  open_issue = FALSE,
  force_update = FALSE
)
}
\arguments{
\item{repo}{Location of repository for which contributions are to be
extracted. This must be a git project with a github remote.}

\item{ncols}{Number of columns for contributors in 'README'}

\item{files}{Names of files in which to add contributors}

\item{type}{Type of contributions to include: 'code' for direct code
contributions (including documentation), 'issues' to recognise contributors
who open issues, and 'discussion' for contributing to discussions within
issues. Discussion contributions are only from individuals not present in
either 'issues' or 'code'; and 'issues' contributions are only from
individuals not present in 'code'.}

\item{exclude_label}{Exclude any contributions from issues with specified
label (default = "wontfix"; set to \code{NULL} or empty string to include all
issues).}

\item{exclude_issues}{Numbers of any issues (or pull requests) to be excluded
from lists of contributors.}

\item{exclude_not_planned}{If \code{TRUE} (default), exclude contributions to any
issues closed as "not planned".}

\item{num_sections}{Number of sections in which to divide contributors:
\itemize{
\item{1} All contributions within single section regardless of \code{type}
\item{2} Contributions divided between a single section for \code{code} and a
second section for all other issue-related contributions.
\item{3} Contributions divided into single sections for each of the three
\code{type} arguments.
}}

\item{section_names}{Names of the sections to appear on the nominated
\code{files}.}

\item{format}{One of ("grid", "list", "text") to control display of
contributors as
\itemize{
\item{1} "grid" for a rectangular grid, with each contributor represented by
their github avatar, with avatar linked to contributor profile and name
linked to repository contributions.
\item{2} "list" for a more condensed list with github user names only
and no avatars, one contributor per line linked to issue contributions.
\item{3} "text" for a single line of text containing comma-separated github
user names linked to issue contributions.
}}

\item{alphabetical}{If \code{TRUE}, order contributors alphabetically, otherwise
order by decreasing numbers of contributions.}

\item{open_issue}{If \code{TRUE}, open or edit an issue on github in order to
notify all contributors that they've been added to your \code{README} (see Note).}

\item{force_update}{If \code{TRUE}, update the specified files even if
contributions have not changed.}
}
\value{
Named list of logical values indicating whether files of given names
were updated or not is returned invisibly (that is, only if explicitly
assigned to a return value).
}
\description{
Add contributors to README.Rmd
}
\note{
Opening an issue on github requires the github command-line interface
to be locally installed. See \url{https://cli.github.com/}.
}
\examples{
# The following code extracts the contributors from the git repository
# associated with current working directory and writes them to a file.
\dontrun{
f <- tempfile (fileext = ".Rmd")
writeLines ("", f) # blank file in tempdir()
add_contributors (repo = ".", files = f)
}
}
\seealso{
Other main: 
\code{\link{get_contributors}()}
}
\concept{main}
