% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{aou_codebook}
\alias{aou_codebook}
\title{All of Us Modified Codebook}
\format{
\code{aou_codebook} A data frame with 702 rows and 11 columns:
\describe{
\item{concept_code}{chr; Concept code from AOU codebook}
\item{concept_id}{int; mapped concept_id from PPI vocabulary}
\item{concept_name}{chr; Formatted text name of concept}
\item{concept_class_id}{chr; type of survey item - question or answer}
\item{form_name}{int; name of survey}
\item{field_type}{chr; type of question (radio, text, checkbox etc.)}
\item{field_label}{chr; The actual text of the question or answer}
\item{choices}{int; choices for question if radio or checkbox}
\item{standard_concept}{chr; Whether concept_id is a standard omop concept}
\item{valid_start_Date}{chr; start date for concept}
\item{valid_end_Date}{int; end date for concept}
\item{link}{chr; link to survey pdf}
}
}
\usage{
aou_codebook
}
\description{
A data frame with rows from the publicly available All of Us
Survey Codebook mapped to the All of Us PPI Vocabulary available on Athena.
A small number of rows did not match between the codebook and the Athena
PPI Vocabulary.
}
\details{
Questions relating to specific conditions are not included as part
of this table. They are instead available in the \code{aou_health_history}
table.

\itemize{
\item{\href{https://docs.google.com/spreadsheets/d/1Ey8MScRYZ9QyS4izVYScISLMb62QEhSM-ErbG27dNtw/edit#gid=1832128489}{All of Us codebook}}
\item{\href{https://github.com/roux-ohdsi/allofus/blob/main/data-raw/pkg_data.R}{Code to generate table}}
}
}
\keyword{datasets}
