% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{vcov.feglm}
\alias{vcov.feglm}
\title{Extract estimates of the covariance matrix}
\usage{
\method{vcov}{feglm}(object, type = c("empirical.hessian",
  "outer.product", "sandwich", "clustered"), cluster.vars = NULL, ...)
}
\arguments{
\item{object}{an object of class \code{feglm}.}

\item{type}{the type of covariance estimate required. \code{"empirical.hessian"} refers to the inverse
of the negative Hessian after convergence and is the default option. \code{"outer.product"} is
the outer-product-of-the-gradient estimator, \code{"sandwich"} is the sandwich estimator 
(sometimes also refered as robust estimator), and \code{"clustered"} computes a clustered
covariance matrix given some cluster variables.}

\item{cluster.vars}{a character or vector of characters indicating the names of the cluster variables in
the data set.}

\item{...}{other arguments.}
}
\value{
The function \code{\link{vcov.feglm}} returns a named matrix of covariance estimates.
}
\description{
\code{vcov.feglm} computes an estimate of the covariance matrix of the estimator of the
structural parameters from objects returned by \code{\link{feglm}}. The estimate is obtained
using the Hessian, the scores, or a combination of boths after convergence.
}
\details{
Multi-way clustering is done using the algorithm of Cameron, Gelbach, and Miller (2011).
}
\references{
Cameron, C., J. Gelbach, and D. Miller (2011). "Robust Inference With Multiway Clustering".
Journal of Business & Economic Statistics 29(2).
}
\seealso{
\code{\link{feglm}}
}
