% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_docs.R
\name{render_docs}
\alias{render_docs}
\title{Update documentation}
\usage{
render_docs(path = ".", verbose = FALSE, parallel = FALSE, freeze = FALSE)
}
\arguments{
\item{path}{Path to the package root directory.}

\item{verbose}{Logical. Print Rmarkdown or Quarto rendering output.}

\item{parallel}{Logical. Render man pages and vignettes in parallel using the \code{future} framework. In addition to setting this argument to TRUE, users must define the parallelism plan in \code{future}. See the examples section below.}

\item{freeze}{Logical. If TRUE and a man page or vignette has not changed since the last call to \code{render_docs()}, that file is skipped. File hashes are stored in \code{altdoc/freeze.rds}. If that file is deleted, all man pages and vignettes will be rendered anew.}
}
\description{
Render and update the function reference manual, vignettes, README, NEWS, CHANGELOG, LICENSE,
and CODE_OF_CONDUCT sections, if they exist. This function overwrites the
content of the 'docs/' folder. See details below.
}
\details{
This function searches the root directory and the \verb{inst/} directory for specific filenames, renders/converts/copies them to the \verb{docs/} directory. The order of priority for each file is established as follows:
\itemize{
\item \code{docs/README.md}
\itemize{
\item README.md, README.qmd, README.Rmd
}
\item \code{docs/NEWS.md}
\itemize{
\item NEWS.md, NEWS.txt, NEWS, NEWS.Rd
\item Note: Where possible, Github contributors and issues are linked automatically.
}
\item \code{docs/CHANGELOG.md}
\itemize{
\item CHANGELOG.md, CHANGELOG.txt, CHANGELOG
}
\item \code{docs/CODE_OF_CONDUCT.md}
\itemize{
\item CODE_OF_CONDUCT.md, CODE_OF_CONDUCT.txt, CODE_OF_CONDUCT
}
\item \code{docs/LICENSE.md}
\itemize{
\item LICENSE.md, LICENSE.txt, LICENSE
}
\item \code{docs/LICENCE.md}
\itemize{
\item LICENCE.md, LICENCE.txt, LICENCE
}
}
}
\section{Altdoc variables}{


The settings files in the \verb{altdoc/} directory can include \verb{$ALTDOC} variables which are replaced automatically by \code{altdoc} when calling \code{render_docs()}:
\itemize{
\item \verb{$ALTDOC_PACKAGE_NAME}: Name of the package from \code{DESCRIPTION}.
\item \verb{$ALTDOC_PACKAGE_VERSION}: Version number of the package from \code{DESCRIPTION}
\item \verb{$ALTDOC_PACKAGE_URL}: First URL listed in the DESCRIPTION file of the package.
\item \verb{$ALTDOC_PACKAGE_URL_GITHUB}: First URL that contains "github.com" from the URLs listed in the DESCRIPTION file of the package. If no such URL is found, lines containing this variable are removed from the settings file.
\item \verb{$ALTDOC_MAN_BLOCK}: Nested list of links to the individual help pages for each exported function of the package. The format of this block depends on the documentation generator.
\item \verb{$ALTDOC_VIGNETTE_BLOCK}: Nested list of links to the vignettes. The format of this block depends on the documentation generator.
\item \verb{$ALTDOC_VERSION}: Version number of the altdoc package.
}

Also note that you can store images and static files in the \verb{altdoc/} directory. All the files in this folder are copied to \verb{docs/} and made available in the root of the website, so you can link to them easily.
}

\section{Altdoc preambles}{


When you call \code{render_docs()}, \code{altdoc} will automatically paste the content of one of these three files to the top of a document:
\itemize{
\item \code{altdoc/preamble_vignettes_qmd.yml}
\item \code{altdoc/preamble_vignettes_rmd.yml}
\item \code{altdoc/preamble_man_qmd.yml}
}

The README file uses the vignette preamble.

To preempt this behavior, add your own preamble to the README file or to a vignette.
}

\examples{
if (interactive()) {

  render_docs()

  # parallel rendering
  library(future)
  plan(multicore)
  render_docs(parallel = TRUE)

}
}
