% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{download_aqs}
\alias{download_aqs}
\title{Download air quality data}
\usage{
download_aqs(
  parameter_code = 88101,
  resolution_temporal = "daily",
  year = c(2018, 2022),
  url_aqs_download = "https://aqs.epa.gov/aqsweb/airdata/",
  directory_to_save = NULL,
  acknowledgement = FALSE,
  download = FALSE,
  remove_command = FALSE,
  unzip = TRUE,
  remove_zip = FALSE
)
}
\arguments{
\item{parameter_code}{integer(1). length of 5.
EPA pollutant parameter code. For details, please refer to
\href{https://aqs.epa.gov/aqsweb/documents/codetables/parameters.html}{AQS parameter codes}}

\item{resolution_temporal}{character(1).
Name of column containing POC values.
Currently, no value other than \code{"daily"} works.}

\item{year}{character(2). length of 4 each. Start/end years for downloading data.}

\item{url_aqs_download}{character(1).
URL to the AQS pre-generated datasets.}

\item{directory_to_save}{character(1). Directory to save data. Two
sub-directories will be created for the downloaded zip files ("/zip_files")
and the unzipped data files ("/data_files").}

\item{acknowledgement}{logical(1). By setting \code{TRUE} the
user acknowledges that the data downloaded using this function may be very
large and use lots of machine storage and memory.}

\item{download}{logical(1). \code{FALSE} will generate a *.txt file
containing all download commands. By setting \code{TRUE} the function
will download all of the requested data files.}

\item{remove_command}{logical(1).
Remove (\code{TRUE}) or keep (\code{FALSE})
the text file containing download commands. Default is FALSE.}

\item{unzip}{logical(1). Unzip zip files. Default \code{TRUE}.}

\item{remove_zip}{logical(1). Remove zip file from directory_to_download.
Default \code{FALSE}.}
}
\value{
NULL; Zip and/or data files will be downloaded and stored in
\code{directory_to_save}.
}
\description{
The \code{download_aqs()} function accesses and downloads Air Quality System (AQS) data from the \href{https://aqs.epa.gov/aqsweb/airdata/download_files.html}{U.S. Environmental Protection Agency's (EPA) Pre-Generated Data Files}.
}
\examples{
download_aqs(
  parameter_code = 88101,
  resolution_temporal = "daily",
  year = c(2023, 2023),
  directory_to_save = tempdir(),
  acknowledgement = TRUE,
  download = FALSE, # NOTE: download skipped for examples,
  remove_command = TRUE,
  unzip = FALSE
)
}
\references{
\insertRef{data_usepa2023airdata}{amadeus}
}
\author{
Mariana Kassien, Insang Song, Mitchell Manware
}
