% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_covariates_auxiliary.R
\name{calc_prepare_locs}
\alias{calc_prepare_locs}
\title{Prepare extraction locations}
\usage{
calc_prepare_locs(from, locs, locs_id, radius, geom = FALSE)
}
\arguments{
\item{from}{SpatRaster(1) or SpatVector(1). Output from
\code{process_\*()}. Passed from \code{calc_\*()}.}

\item{locs}{data.frame. character to file path, SpatVector, or sf object.
Passed from \code{calc_\*()}.}

\item{locs_id}{character(1). Column within \code{locations} CSV file
containing identifier for each unique coordinate location.
Passed from \code{calc_\*()}.}

\item{radius}{integer(1). Circular buffer distance around site locations.
(Default = 0). Passed from \code{calc_\*()}.}

\item{geom}{logical(1). Should the geometry of \code{locs} be returned in the
\code{data.frame}? Default is \code{FALSE}.}
}
\value{
A \code{list} containing \code{SpatVector} and \code{data.frame} objects
}
\description{
Prepare the point locations for extracting data by transforming \code{locs} to
a \code{SpatVector}, projecting to the coordinate reference system of \code{from},
and creating a \code{data.frame} containing \code{locs_id} for retaining extracted
values.
}
\seealso{
\code{\link[=process_locs_vector]{process_locs_vector()}}, \code{\link[=check_for_null_parameters]{check_for_null_parameters()}}
}
\keyword{internal}
