% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{download_huc}
\alias{download_huc}
\title{Download National Hydrography Dataset (NHD) data}
\usage{
download_huc(
  region = c("Lower48", "Islands"),
  type = c("Seamless", "OceanCatchment"),
  directory_to_save = NULL,
  acknowledgement = FALSE,
  download = FALSE,
  remove_command = FALSE,
  unzip = FALSE,
  hash = FALSE
)
}
\arguments{
\item{region}{character(1). One of \code{c("Lower48", "Islands")}.
When \code{"Islands"} is selected, the data will be downloaded for Hawaii, Puerto Rico, and Virgin Islands.}

\item{type}{character(1). One of \code{c("Seamless", "OceanCatchment")}.}

\item{directory_to_save}{character(1). Directory to download files.}

\item{acknowledgement}{logical(1). By setting \code{TRUE} the
user acknowledges that the data downloaded using this function may be very
large and use lots of machine storage and memory.}

\item{download}{logical(1). \code{FALSE} will generate a *.txt file
containing all download commands. By setting \code{TRUE} the function
will download all of the requested data files.}

\item{remove_command}{logical(1).
Remove (\code{TRUE}) or keep (\code{FALSE})
the text file containing download commands.}

\item{unzip}{logical(1). Unzip the downloaded compressed files.
Default is \code{FALSE}. Not working for this function since HUC data is in 7z format.}

\item{hash}{logical(1). By setting \code{TRUE} the function will return
an \code{rlang::hash_file()} hash character corresponding to the
downloaded files. Default is \code{FALSE}.}
}
\value{
\itemize{
\item For \code{hash = FALSE}, NULL
\item For \code{hash = TRUE}, an \code{rlang::hash_file} character.
\item Downloaded files will be stored in \code{directory_to_save}.
}
}
\description{
NHDPlus data provides the most comprehensive and high-resolution
hydrography data. This function downloads \strong{national} dataset from
NHDPlus Version 2.1 on USGS Amazon S3 storage.
}
\note{
For HUC, set \code{type = "Seamless"}. HUC12 layer presents in the seamless
geodatabase. Users can aggregate HUC12 layer to make HUC6, HUC8, HUC10, etc.
For whom wants to download a specific region,
please visit \href{https://www.epa.gov/waterdata/get-nhdplus-national-hydrography-dataset-plus-data#ListofAreas}{Get NHDPlus Data}
}
\examples{
\dontrun{
download_huc(
  region = "Lower48",
  type = "Seamless",
  directory_to_save = tempdir(),
  acknowledgement = TRUE,
  download = FALSE, # NOTE: download skipped for examples,
  remove_command = TRUE,
  unzip = FALSE
)
}
}
\references{
\insertRef{data_usgs2023nhd}{amadeus}
}
\author{
Insang Song
}
