% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intFun.R
\name{intFun.grid.significance}
\alias{intFun.grid.significance}
\title{Set significant differences to NA}
\usage{
intFun.grid.significance(x)
}
\arguments{
\item{x}{A raster object}
}
\value{
A raster object
}
\description{
This function sets all values that are equal or less than 0.05
to NA. Applied to a raster that shows the p-values of a significance
test, the function sets all statistically significant differences to NA
at the 5 percent level.
}
\examples{

library(raster)
# make some data
data <- runif(100,0,1)
data <- matrix(data, ncol=10)
data <- raster::raster(data)
# repeat raster stack 10 times
data <- intFun.grid.significance(data)
plot(data); text(data, digits=2)

}
\keyword{internal}
